/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.FixedBitSet;
import solutions.siren.join.action.terms.collector.HitStream;

public class BitSetHitStream
extends HitStream {
    private int count = 0;
    private int currentAtomicReaderId = 0;
    private int currentAtomicDocId = -1;

    public BitSetHitStream(Query query, IndexSearcher searcher) throws IOException {
        super((Query)new ConstantScoreQuery(query), new LimitedBitSetHitCollector(searcher.getIndexReader().leaves().size()), searcher);
    }

    @Override
    public int getTotalHits() {
        return ((LimitedBitSetHitCollector)this.getCollector()).getTotalHits();
    }

    @Override
    public int getHits() {
        return this.getTotalHits();
    }

    @Override
    public boolean hasNext() {
        return this.count < this.getHits();
    }

    @Override
    public void next() {
        LimitedBitSetHitCollector collector = (LimitedBitSetHitCollector)this.getCollector();
        int atomicDocId = this.currentAtomicDocId;
        if (this.currentAtomicReaderId < collector.getFixedSets().size()) {
            do {
                FixedBitSet bitSet = collector.getFixedSets().get(this.currentAtomicReaderId);
                if (atomicDocId == Integer.MAX_VALUE) {
                    atomicDocId = -1;
                }
                int n = atomicDocId = atomicDocId + 1 < bitSet.length() ? bitSet.nextSetBit(atomicDocId + 1) : Integer.MAX_VALUE;
            } while (atomicDocId == Integer.MAX_VALUE && ++this.currentAtomicReaderId < collector.getFixedSets().size());
        }
        this.currentAtomicDocId = atomicDocId;
        ++this.count;
    }

    @Override
    public int getAtomicDocId() {
        return this.currentAtomicDocId;
    }

    @Override
    public int getAtomicReaderId() {
        return this.currentAtomicReaderId;
    }

    private static class LimitedBitSetHitCollector
    implements Collector {
        private int totalHits;
        private final List<FixedBitSet> fixedBitSets;
        private FixedBitSet current;

        public LimitedBitSetHitCollector(int numSegments) {
            this.fixedBitSets = new ArrayList<FixedBitSet>(numSegments);
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.current = new FixedBitSet(context.reader().maxDoc());
            this.fixedBitSets.add(context.ord, this.current);
            return new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    LimitedBitSetHitCollector.this.current.set(doc);
                    LimitedBitSetHitCollector.this.totalHits++;
                }
            };
        }

        public boolean needsScores() {
            return false;
        }

        public List<FixedBitSet> getFixedSets() {
            return this.fixedBitSets;
        }

        public int getTotalHits() {
            return this.totalHits;
        }
    }
}

