/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.TermsByQueryResponse;
import solutions.siren.join.action.terms.TermsByQueryShardRequest;
import solutions.siren.join.action.terms.TermsByQueryShardResponse;
import solutions.siren.join.action.terms.collector.BitSetHitStream;
import solutions.siren.join.action.terms.collector.BloomFilterTermsCollector;
import solutions.siren.join.action.terms.collector.BytesRefTermsCollector;
import solutions.siren.join.action.terms.collector.HitStream;
import solutions.siren.join.action.terms.collector.IntegerTermsCollector;
import solutions.siren.join.action.terms.collector.LongTermsCollector;
import solutions.siren.join.action.terms.collector.TermsCollector;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.action.terms.collector.TopHitStream;

public class TransportTermsByQueryAction
extends TransportBroadcastAction<TermsByQueryRequest, TermsByQueryResponse, TermsByQueryShardRequest, TermsByQueryShardResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final CircuitBreakerService breakerService;
    private final Client client;

    @Inject
    public TransportTermsByQueryAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, CircuitBreakerService breakerService, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "indices:data/read/search/termsbyquery", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermsByQueryRequest.class, TermsByQueryShardRequest.class, "generic");
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.breakerService = breakerService;
        this.client = client;
    }

    protected void doExecute(Task task, TermsByQueryRequest request, ActionListener<TermsByQueryResponse> listener) {
        request.nowInMillis(System.currentTimeMillis());
        super.doExecute(task, (BroadcastRequest)request, listener);
    }

    protected TermsByQueryShardRequest newShardRequest(int numShards, ShardRouting shard, TermsByQueryRequest request) {
        String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterService.state(), shard.index(), request.indices());
        return new TermsByQueryShardRequest(shard.shardId(), filteringAliases, request);
    }

    protected TermsByQueryShardResponse newShardResponse() {
        return new TermsByQueryShardResponse(this.breakerService.getBreaker("request"));
    }

    protected GroupShardsIterator shards(ClusterState clusterState, TermsByQueryRequest request, String[] concreteIndices) {
        Map routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, request.routing(), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, TermsByQueryRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, TermsByQueryRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TermsByQueryResponse newResponse(TermsByQueryRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        int numTerms = 0;
        TermsSet[] termsSets = new TermsSet[shardsResponses.length()];
        ArrayList<ShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            TermsSet terms;
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<ShardOperationFailedException>();
                }
                this.logger.error("Shard operation failed", (Throwable)((BroadcastShardOperationFailedException)shardResponse), new Object[0]);
                shardFailures.add((ShardOperationFailedException)new DefaultShardOperationFailedException((ElasticsearchException)((BroadcastShardOperationFailedException)shardResponse)));
                continue;
            }
            TermsByQueryShardResponse shardResp = (TermsByQueryShardResponse)((Object)shardResponse);
            termsSets[i] = terms = shardResp.getTerms();
            numTerms += terms.size();
            ++successfulShards;
        }
        try {
            TermsByQueryResponse rsp;
            long expectedElements = request.expectedTerms() != null ? request.expectedTerms() : (long)numTerms;
            TermsSet termsSet = TermsSet.newTermsSet(expectedElements, request.termsEncoding(), this.breakerService.getBreaker("request"));
            try {
                for (int i = 0; i < termsSets.length; ++i) {
                    TermsSet terms = termsSets[i];
                    if (terms == null) continue;
                    termsSet.merge(terms);
                    terms.release();
                    termsSets[i] = null;
                }
                long tookInMillis = System.currentTimeMillis() - request.nowInMillis();
                rsp = new TermsByQueryResponse(termsSet, tookInMillis, shardsResponses.length(), successfulShards, failedShards, shardFailures);
            }
            finally {
                termsSet.release();
            }
            TermsByQueryResponse termsByQueryResponse = rsp;
            return termsByQueryResponse;
        }
        finally {
            for (int i = 0; i < termsSets.length; ++i) {
                TermsSet terms = termsSets[i];
                if (terms == null) continue;
                terms.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TermsByQueryShardResponse shardOperation(TermsByQueryShardRequest shardRequest) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRequest.shardId().getIndex());
        IndexShard indexShard = indexService.shardSafe(shardRequest.shardId().id());
        TermsByQueryRequest request = shardRequest.request();
        OrderByShardOperation orderByOperation = OrderByShardOperation.get(request.getOrderBy(), request.maxTermsPerShard());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), shardRequest.shardId().getIndex(), shardRequest.shardId().id());
        ShardSearchLocalRequest shardSearchRequest = new ShardSearchLocalRequest(request.types(), request.nowInMillis(), shardRequest.filteringAliases());
        DefaultSearchContext context = new DefaultSearchContext(0L, (ShardSearchRequest)shardSearchRequest, shardTarget, indexShard.acquireSearcher("termsByQuery"), indexService, indexShard, this.scriptService, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), this.parseFieldMatcher, SearchService.NO_TIMEOUT);
        SearchContext.setCurrent((SearchContext)context);
        try {
            MappedFieldType fieldType = context.smartNameFieldType(request.field());
            if (fieldType == null) {
                throw new SearchContextException((SearchContext)context, "[termsByQuery] field '" + request.field() + "' not found for types " + Arrays.toString(request.types()));
            }
            IndexFieldData indexFieldData = context.fieldData().getForField(fieldType);
            BytesReference querySource = request.querySource();
            if (querySource != null && querySource.length() > 0) {
                XContentParser queryParser = null;
                try {
                    queryParser = XContentFactory.xContent((BytesReference)querySource).createParser(querySource);
                    QueryParseContext.setTypes((String[])request.types());
                    ParsedQuery parsedQuery = orderByOperation.getParsedQuery(queryParser, indexService);
                    if (parsedQuery != null) {
                        context.parsedQuery(parsedQuery);
                    }
                }
                finally {
                    QueryParseContext.removeTypes();
                    if (queryParser != null) {
                        queryParser.close();
                    }
                }
            }
            context.preProcess();
            this.logger.debug("{}: Executes search for collecting terms {}", new Object[]{Thread.currentThread().getName(), shardRequest.shardId()});
            TermsCollector termsCollector = this.getTermsCollector(request.termsEncoding(), indexFieldData, (SearchContext)context);
            if (request.expectedTerms() != null) {
                termsCollector.setExpectedTerms(request.expectedTerms());
            }
            if (request.maxTermsPerShard() != null) {
                termsCollector.setMaxTerms(request.maxTermsPerShard());
            }
            HitStream hitStream = orderByOperation.getHitStream((SearchContext)context);
            TermsSet terms = termsCollector.collect(hitStream);
            this.logger.debug("{}: Returns terms response with {} terms for shard {}", new Object[]{Thread.currentThread().getName(), terms.size(), shardRequest.shardId()});
            TermsByQueryShardResponse termsByQueryShardResponse = new TermsByQueryShardResponse(shardRequest.shardId(), terms);
            return termsByQueryShardResponse;
        }
        catch (Throwable e) {
            this.logger.error("[termsByQuery] Error executing shard operation", e, new Object[0]);
            throw new QueryPhaseExecutionException((SearchContext)context, "[termsByQuery] Failed to execute query", e);
        }
        finally {
            context.close();
            SearchContext.removeCurrent();
        }
    }

    private TermsCollector getTermsCollector(TermsByQueryRequest.TermsEncoding termsEncoding, IndexFieldData indexFieldData, SearchContext context) {
        switch (termsEncoding) {
            case LONG: {
                return new LongTermsCollector(indexFieldData, context, this.breakerService.getBreaker("request"));
            }
            case INTEGER: {
                return new IntegerTermsCollector(indexFieldData, context, this.breakerService.getBreaker("request"));
            }
            case BLOOM: {
                return new BloomFilterTermsCollector(indexFieldData, context, this.breakerService.getBreaker("request"));
            }
            case BYTES: {
                return new BytesRefTermsCollector(indexFieldData, context, this.breakerService.getBreaker("request"));
            }
        }
        throw new IllegalArgumentException("[termsByQuery] Invalid terms encoding: " + termsEncoding.name());
    }

    private static class OrderByDocScoreShardOperation
    extends OrderByShardOperation {
        private OrderByDocScoreShardOperation(Integer maxTermsPerShard) {
            super(maxTermsPerShard);
        }

        @Override
        protected HitStream getHitStream(SearchContext context) throws IOException {
            if (this.maxTermsPerShard == null) {
                throw new ElasticsearchParseException("[termsByQuery] maxTermsPerShard parameter is null", new Object[0]);
            }
            return new TopHitStream(this.maxTermsPerShard, context.query(), (IndexSearcher)context.searcher());
        }
    }

    private static class OrderByDefaultShardOperation
    extends OrderByShardOperation {
        private OrderByDefaultShardOperation(Integer maxTermsPerShard) {
            super(maxTermsPerShard);
        }

        @Override
        protected HitStream getHitStream(SearchContext context) throws IOException {
            return new BitSetHitStream(context.query(), (IndexSearcher)context.searcher());
        }
    }

    private static abstract class OrderByShardOperation {
        protected final Integer maxTermsPerShard;

        private OrderByShardOperation(Integer maxTermsPerShard) {
            this.maxTermsPerShard = maxTermsPerShard;
        }

        protected ParsedQuery getParsedQuery(XContentParser queryParser, IndexService indexService) {
            return indexService.queryParserService().parse(queryParser);
        }

        protected abstract HitStream getHitStream(SearchContext var1) throws IOException;

        private static OrderByShardOperation get(TermsByQueryRequest.Ordering orderBy, Integer maxTermsPerShard) {
            TermsByQueryRequest.Ordering ordering = orderBy != null ? orderBy : TermsByQueryRequest.Ordering.DEFAULT;
            switch (ordering) {
                case DEFAULT: {
                    return new OrderByDefaultShardOperation(maxTermsPerShard);
                }
                case DOC_SCORE: {
                    return new OrderByDocScoreShardOperation(maxTermsPerShard);
                }
            }
            throw new ElasticsearchParseException("[termsByQuery] unknown ordering " + ordering.name(), new Object[0]);
        }
    }
}

