/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.BloomFilterTermsSet;
import solutions.siren.join.action.terms.collector.BytesRefTermsSet;
import solutions.siren.join.action.terms.collector.IntegerTermsSet;
import solutions.siren.join.action.terms.collector.LongTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;

class TermsByQueryShardResponse
extends BroadcastShardResponse {
    private TermsSet termsSet;
    private final CircuitBreaker breaker;

    TermsByQueryShardResponse(CircuitBreaker breaker) {
        this.breaker = breaker;
    }

    public TermsByQueryShardResponse(ShardId shardId, TermsSet termsSet) {
        super(shardId);
        this.termsSet = termsSet;
        this.breaker = null;
    }

    public TermsSet getTerms() {
        return this.termsSet;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        TermsByQueryRequest.TermsEncoding termsEncoding = TermsByQueryRequest.TermsEncoding.values()[in.readVInt()];
        switch (termsEncoding) {
            case LONG: {
                this.termsSet = new LongTermsSet(this.breaker);
                this.termsSet.readFrom(in);
                return;
            }
            case INTEGER: {
                this.termsSet = new IntegerTermsSet(this.breaker);
                this.termsSet.readFrom(in);
                return;
            }
            case BLOOM: {
                this.termsSet = new BloomFilterTermsSet(this.breaker);
                this.termsSet.readFrom(in);
                return;
            }
            case BYTES: {
                this.termsSet = new BytesRefTermsSet(this.breaker);
                this.termsSet.readFrom(in);
                return;
            }
        }
        throw new IOException("[termsByQuery] Invalid type of terms encoding: " + termsEncoding.name());
    }

    public void writeTo(StreamOutput out) throws IOException {
        try {
            super.writeTo(out);
            out.writeVInt(this.termsSet.getEncoding().ordinal());
            this.termsSet.writeTo(out);
        }
        finally {
            this.termsSet.release();
        }
    }
}

