/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.TermsSet;

public class TermsByQueryResponse
extends BroadcastResponse {
    private BytesRef encodedTerms;
    private int size;
    private TermsByQueryRequest.TermsEncoding termsEncoding;
    private boolean isPruned;
    private long tookInMillis;

    TermsByQueryResponse() {
    }

    TermsByQueryResponse(TermsSet termsSet, long tookInMillis, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.encodedTerms = termsSet.writeToBytes();
        this.termsEncoding = termsSet.getEncoding();
        this.size = termsSet.size();
        this.isPruned = termsSet.isPruned();
        this.tookInMillis = tookInMillis;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public BytesRef getEncodedTermsSet() {
        return this.encodedTerms;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPruned() {
        return this.isPruned;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.isPruned = in.readBoolean();
        this.size = in.readVInt();
        this.termsEncoding = TermsByQueryRequest.TermsEncoding.values()[in.readVInt()];
        this.encodedTerms = in.readBytesRef();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.isPruned);
        out.writeVInt(this.size);
        out.writeVInt(this.termsEncoding.ordinal());
        out.writeBytesRef(this.encodedTerms);
        this.encodedTerms = null;
    }
}

