/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.QueryBuilder;

public class TermsByQueryRequest
extends BroadcastRequest<TermsByQueryRequest> {
    @Nullable
    protected String routing;
    private long nowInMillis;
    @Nullable
    private String preference;
    private BytesReference querySource;
    @Nullable
    private String[] types = Strings.EMPTY_ARRAY;
    private String field;
    @Nullable
    private Ordering ordering;
    @Nullable
    private Integer maxTermsPerShard;
    @Nullable
    private TermsEncoding termsEncoding;
    @Nullable
    private Long expectedTerms;
    public static final TermsEncoding DEFAULT_TERM_ENCODING = TermsEncoding.LONG;

    public TermsByQueryRequest() {
    }

    public TermsByQueryRequest(ActionRequest originalRequest, String ... indices) {
        super(originalRequest);
        this.indices(indices);
    }

    public TermsByQueryRequest(String ... indices) {
        super(indices);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.termsEncoding != null && this.termsEncoding.equals((Object)TermsEncoding.BYTES) && this.maxTermsPerShard == null) {
            validationException = ValidateActions.addValidationError((String)"maxTermsPerShard not specified for terms encoding [bytes]", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String field() {
        return this.field;
    }

    public TermsByQueryRequest field(String field) {
        this.field = field;
        return this;
    }

    public BytesReference querySource() {
        return this.querySource;
    }

    public TermsByQueryRequest query(QueryBuilder queryBuilder) {
        this.querySource = queryBuilder == null ? null : queryBuilder.buildAsBytes();
        return this;
    }

    public TermsByQueryRequest query(XContentBuilder builder) {
        this.querySource = builder == null ? null : builder.bytes();
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public TermsByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public TermsByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public TermsByQueryRequest nowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
        return this;
    }

    public TermsByQueryRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString((Object[])routings);
        return this;
    }

    public TermsByQueryRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public TermsByQueryRequest orderBy(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    public Ordering getOrderBy() {
        return this.ordering;
    }

    public TermsByQueryRequest maxTermsPerShard(Integer maxTermsPerShard) {
        this.maxTermsPerShard = maxTermsPerShard;
        return this;
    }

    public Integer maxTermsPerShard() {
        return this.maxTermsPerShard;
    }

    public TermsByQueryRequest termsEncoding(TermsEncoding termsEncoding) {
        this.termsEncoding = termsEncoding;
        return this;
    }

    public TermsEncoding termsEncoding() {
        return this.termsEncoding == null ? DEFAULT_TERM_ENCODING : this.termsEncoding;
    }

    public TermsByQueryRequest expectedTerms(Long expectedTerms) {
        this.expectedTerms = expectedTerms;
        return this;
    }

    public Long expectedTerms() {
        return this.expectedTerms;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.querySource = in.readBoolean() ? in.readBytesReference() : null;
        if (in.readBoolean()) {
            this.types = in.readStringArray();
        }
        this.field = in.readString();
        this.nowInMillis = in.readVLong();
        if (in.readBoolean()) {
            this.ordering = Ordering.values()[in.readVInt()];
        }
        if (in.readBoolean()) {
            this.maxTermsPerShard = in.readVInt();
        }
        if (in.readBoolean()) {
            this.termsEncoding = TermsEncoding.values()[in.readVInt()];
        }
        if (in.readBoolean()) {
            this.expectedTerms = in.readVLong();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (this.querySource != null) {
            out.writeBoolean(true);
            out.writeBytesReference(this.querySource);
        } else {
            out.writeBoolean(false);
        }
        if (this.types == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeStringArray(this.types);
        }
        out.writeString(this.field);
        out.writeVLong(this.nowInMillis);
        if (this.ordering == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.ordering.ordinal());
        }
        if (this.maxTermsPerShard == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.maxTermsPerShard.intValue());
        }
        if (this.termsEncoding == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.termsEncoding.ordinal());
        }
        if (this.expectedTerms == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVLong(this.expectedTerms.longValue());
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson((BytesReference)this.querySource, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Arrays.toString(this.indices) + Arrays.toString(this.types) + "[" + this.field + "], querySource[" + sSource + "]";
    }

    public static enum TermsEncoding {
        LONG,
        INTEGER,
        BLOOM,
        BYTES;

    }

    public static enum Ordering {
        DEFAULT,
        DOC_SCORE;

    }
}

