/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.tasks;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import solutions.siren.join.action.coordinate.model.FilterJoinNode;
import solutions.siren.join.action.coordinate.model.FilterJoinTerms;
import solutions.siren.join.action.coordinate.pipeline.NodeTask;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskReporter;
import solutions.siren.join.action.terms.TermsByQueryAction;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.TermsByQueryResponse;

public class TermsByQueryTask
implements NodeTask {
    protected static final ESLogger logger = Loggers.getLogger(TermsByQueryTask.class);

    @Override
    public void execute(final NodeTaskContext context, final NodeTaskReporter reporter) {
        logger.debug("Executing async terms by query action", new Object[0]);
        TermsByQueryRequest termsByQueryReq = this.getTermsByQueryRequest(context.getNode(), context.getVisitor().getParentRequest());
        context.getClient().execute((Action)TermsByQueryAction.INSTANCE, (ActionRequest)termsByQueryReq, (ActionListener)new ActionListener<TermsByQueryResponse>(){

            public void onResponse(TermsByQueryResponse termsByQueryResponse) {
                FilterJoinTerms terms = new FilterJoinTerms();
                terms.setEncodedTerms(termsByQueryResponse.getEncodedTermsSet());
                terms.setPruned(termsByQueryResponse.isPruned());
                terms.setSize(termsByQueryResponse.getSize());
                terms.setTookInMillis(termsByQueryResponse.getTookInMillis());
                context.getVisitor().getCache().put(context.getNode().getCacheId(), terms);
                context.getNode().setTerms(terms);
                reporter.success(context);
            }

            public void onFailure(Throwable e) {
                reporter.failure(e);
            }
        });
    }

    protected TermsByQueryRequest getTermsByQueryRequest(FilterJoinNode node, ActionRequest parentRequest) {
        String[] lookupIndices = node.getLookupIndices();
        String[] lookupTypes = node.getLookupTypes();
        String lookupPath = node.getLookupPath();
        XContentBuilder lookupQuery = node.getLookupQuery();
        TermsByQueryRequest.Ordering ordering = node.getOrderBy();
        Integer maxTermsPerShard = node.getMaxTermsPerShard();
        TermsByQueryRequest.TermsEncoding termsEncoding = node.getTermsEncoding();
        TermsByQueryRequest request = new TermsByQueryRequest(parentRequest, lookupIndices).field(lookupPath).types(lookupTypes).query(lookupQuery).orderBy(ordering).maxTermsPerShard(maxTermsPerShard).termsEncoding(termsEncoding);
        if (node.hasCardinality()) {
            request.expectedTerms(node.getCardinality());
        }
        return request;
    }
}

