/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.tasks;

import java.util.Arrays;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.admin.version.GetIndicesVersionAction;
import solutions.siren.join.action.admin.version.GetIndicesVersionRequest;
import solutions.siren.join.action.admin.version.GetIndicesVersionResponse;
import solutions.siren.join.action.coordinate.pipeline.NodeTask;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskReporter;

public class IndicesVersionTask
implements NodeTask {
    protected static final ESLogger logger = Loggers.getLogger(IndicesVersionTask.class);

    @Override
    public void execute(final NodeTaskContext context, final NodeTaskReporter reporter) {
        logger.debug("Executing async get indices version action on indices: {}", new Object[]{Arrays.toString(context.getNode().getLookupIndices())});
        GetIndicesVersionRequest indicesVersionRequest = new GetIndicesVersionRequest(context.getVisitor().getParentRequest(), context.getNode().getLookupIndices());
        context.getClient().execute((Action)GetIndicesVersionAction.INSTANCE, (ActionRequest)indicesVersionRequest, (ActionListener)new ActionListener<GetIndicesVersionResponse>(){

            public void onResponse(GetIndicesVersionResponse response) {
                logger.debug("Got version {} for indices: {}", new Object[]{response.getVersion(), Arrays.toString(context.getNode().getLookupIndices())});
                context.getNode().setIndicesVersion(response.getVersion());
                reporter.success(context);
            }

            public void onFailure(Throwable e) {
                reporter.failure(e);
            }
        });
    }
}

