/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.tasks;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import solutions.siren.join.action.coordinate.model.FilterJoinNode;
import solutions.siren.join.action.coordinate.pipeline.NodeTask;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskReporter;
import solutions.siren.join.action.terms.TermsByQueryRequest;

public class CardinalityEstimationTask
implements NodeTask {
    protected static final ESLogger logger = Loggers.getLogger(CardinalityEstimationTask.class);

    @Override
    public void execute(NodeTaskContext context, NodeTaskReporter reporter) {
        if (context.getNode().getTermsEncoding().equals((Object)TermsByQueryRequest.TermsEncoding.BLOOM)) {
            this.executeCardinalityRequest(context, reporter);
        } else {
            reporter.success(context);
        }
    }

    protected void executeCardinalityRequest(final NodeTaskContext context, final NodeTaskReporter reporter) {
        logger.debug("Executing async cardinality action", new Object[0]);
        SearchRequest cardinalityRequest = this.getCardinalityRequest(context.getNode(), context.getVisitor().getParentRequest());
        context.getClient().execute((Action)SearchAction.INSTANCE, (ActionRequest)cardinalityRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                Cardinality c = (Cardinality)searchResponse.getAggregations().get(context.getNode().getLookupPath());
                context.getNode().setCardinality(c.getValue());
                reporter.success(context);
            }

            public void onFailure(Throwable e) {
                reporter.failure(e);
            }
        });
    }

    protected SearchRequest getCardinalityRequest(FilterJoinNode node, ActionRequest parentRequest) {
        String[] lookupIndices = node.getLookupIndices();
        String[] lookupTypes = node.getLookupTypes();
        String lookupPath = node.getLookupPath();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(0).aggregation((AbstractAggregationBuilder)AggregationBuilders.cardinality((String)lookupPath).field(lookupPath));
        SearchRequest searchRequest = new SearchRequest(parentRequest);
        searchRequest.indices(lookupIndices).types(lookupTypes).source(sourceBuilder);
        return searchRequest;
    }
}

