/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.tasks;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.coordinate.execution.FilterJoinCache;
import solutions.siren.join.action.coordinate.model.FilterJoinNode;
import solutions.siren.join.action.coordinate.model.FilterJoinTerms;
import solutions.siren.join.action.coordinate.pipeline.NodeTask;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskReporter;

public class CacheLookupTask
implements NodeTask {
    protected static final ESLogger logger = Loggers.getLogger(CacheLookupTask.class);

    @Override
    public void execute(NodeTaskContext context, NodeTaskReporter reporter) {
        FilterJoinNode node = context.getNode();
        FilterJoinCache.CacheEntry cacheEntry = context.getVisitor().getCache().get(node.getCacheId());
        if (cacheEntry == null) {
            logger.debug("Cache miss for terms by query action: {}", new Object[]{node.getCacheId()});
            reporter.success(context);
        } else {
            logger.debug("Cache hit for terms by query action: {}", new Object[]{node.getCacheId()});
            FilterJoinTerms terms = new FilterJoinTerms();
            terms.setEncodedTerms(cacheEntry.encodedTerms);
            terms.setSize(cacheEntry.size);
            terms.setPruned(cacheEntry.isPruned);
            terms.setCacheHit(true);
            context.getNode().setTerms(terms);
            reporter.terminate();
        }
    }
}

