/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.pipeline;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import solutions.siren.join.action.coordinate.pipeline.NodePipelineListener;
import solutions.siren.join.action.coordinate.pipeline.NodeTask;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskReporter;

public class NodePipelineManager {
    private Queue<NodeTask> taskQueue;
    private List<NodeTask> tasks = new ArrayList<NodeTask>();
    private NodePipelineListener listener;

    public void addListener(NodePipelineListener listener) {
        this.listener = listener;
    }

    public NodePipelineListener getListener() {
        return this.listener;
    }

    public void addTask(NodeTask task) {
        this.tasks.add(task);
    }

    public void execute(NodeTaskContext context) {
        NodeTaskReporter taskReporter = new NodeTaskReporter(this);
        this.taskQueue = new ArrayDeque<NodeTask>(this.tasks);
        if (!this.taskQueue.isEmpty()) {
            NodeTask task = this.taskQueue.poll();
            task.execute(context, taskReporter);
        } else {
            this.listener.onSuccess();
        }
    }

    void execute(NodeTaskContext context, NodeTaskReporter taskReporter) {
        if (!this.taskQueue.isEmpty()) {
            NodeTask task = this.taskQueue.poll();
            task.execute(context, taskReporter);
        } else {
            this.listener.onSuccess();
        }
    }

    public void terminate() {
        this.taskQueue.clear();
        this.listener.onSuccess();
    }
}

