/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.model;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import solutions.siren.join.action.coordinate.model.AbstractNode;
import solutions.siren.join.action.coordinate.model.FilterJoinTerms;
import solutions.siren.join.action.terms.TermsByQueryRequest;

public class FilterJoinNode
extends AbstractNode {
    private final Map<String, Object> parent;
    private final Map<String, Object> self;
    private final int queryHash;
    private long indicesVersion;
    private long cardinality = 0L;
    private boolean hasCardinality = false;
    private boolean hasFailure = false;
    private Throwable failure;
    private State state;
    private FilterJoinTerms terms;

    public FilterJoinNode(Map<String, Object> parent, Map<String, Object> self) {
        this.parent = parent;
        this.self = self;
        this.state = State.WAITING;
        this.queryHash = self.hashCode();
    }

    public void setFailure(Throwable failure) {
        this.failure = failure;
        this.hasFailure = true;
    }

    public boolean hasFailure() {
        return this.hasFailure;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void setIndicesVersion(long indicesVersion) {
        this.indicesVersion = indicesVersion;
    }

    public long getCacheId() {
        long cacheId = 1L;
        cacheId = 31L * cacheId + (long)this.queryHash;
        cacheId = 31L * cacheId + this.indicesVersion;
        return cacheId;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
        this.hasCardinality = true;
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public String getField() {
        return this.self.keySet().iterator().next();
    }

    public String[] getLookupIndices() {
        Map conf = (Map)this.self.get(this.getField());
        Object o = conf.get("indices");
        if (o == null) {
            return new String[0];
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof List) {
            return ((List)o).toArray(new String[((List)o).size()]);
        }
        throw new ElasticsearchParseException("Unable to build the lookup query - Invalid 'indices' parameter.", new Object[0]);
    }

    public String[] getLookupTypes() {
        Map conf = (Map)this.self.get(this.getField());
        Object o = conf.get("types");
        if (o == null) {
            return new String[0];
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof List) {
            return ((List)o).toArray(new String[((List)o).size()]);
        }
        throw new ElasticsearchParseException("Unable to build the lookup query - Invalid 'types' parameter.", new Object[0]);
    }

    public String getLookupPath() {
        Map conf = (Map)this.self.get(this.getField());
        return (String)conf.get("path");
    }

    public XContentBuilder getLookupQuery() {
        Map conf = (Map)this.self.get(this.getField());
        return this.buildQuery((Map)conf.get("query"));
    }

    public TermsByQueryRequest.Ordering getOrderBy() {
        Map conf = (Map)this.self.get(this.getField());
        String ordering = (String)conf.get("orderBy");
        if (ordering == null) {
            return null;
        }
        return TermsByQueryRequest.Ordering.valueOf(ordering.toUpperCase(Locale.ROOT));
    }

    public Integer getMaxTermsPerShard() {
        Map conf = (Map)this.self.get(this.getField());
        return (Integer)conf.get("maxTermsPerShard");
    }

    public TermsByQueryRequest.TermsEncoding getTermsEncoding() {
        Map conf = (Map)this.self.get(this.getField());
        String termsEncoding = (String)conf.get("termsEncoding");
        if (termsEncoding == null) {
            return TermsByQueryRequest.DEFAULT_TERM_ENCODING;
        }
        return TermsByQueryRequest.TermsEncoding.valueOf(termsEncoding.toUpperCase(Locale.ROOT));
    }

    private XContentBuilder buildQuery(Map query) {
        try {
            if (query == null) {
                return null;
            }
            return XContentBuilder.builder((XContent)XContentType.CBOR.xContent()).map(query);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Unable to build the lookup query", new Object[0]);
        }
    }

    public Map<String, Object> getSourceMap() {
        return this.self;
    }

    public Map<String, Object> getParentSourceMap() {
        return this.parent;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public void setTerms(FilterJoinTerms terms) {
        this.terms = terms;
    }

    public FilterJoinTerms getTerms() {
        return this.terms;
    }

    public static enum State {
        WAITING,
        RUNNING,
        COMPLETED,
        CONVERTED;

    }
}

