/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.execution;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentHelper;

public class WrapperQueryVisitor {
    private final Map map;

    public WrapperQueryVisitor(Map map) {
        this.map = map;
    }

    public void traverse() {
        this.visit(this.map);
    }

    private void visit(Map map) {
        Map<String, Object> query;
        Set entries = map.entrySet();
        if (map.containsKey("wrapper") && (query = this.unwrap(map.get("wrapper"))) != null) {
            map.remove("wrapper");
            Map.Entry<String, Object> entry = query.entrySet().iterator().next();
            map.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : entries) {
            this.visit(entry.getValue());
        }
    }

    private Map<String, Object> unwrap(Object value) {
        Map wrapperQuery;
        if (value instanceof Map && (wrapperQuery = (Map)value).containsKey("query")) {
            Object encodedQuery = wrapperQuery.get("query");
            if (encodedQuery instanceof byte[]) {
                return this.parseQuery((byte[])encodedQuery);
            }
            if (encodedQuery instanceof String) {
                return this.parseQuery((String)encodedQuery);
            }
        }
        return null;
    }

    private void visit(List array) {
        for (Object obj : array) {
            this.visit(obj);
        }
    }

    private void visit(Object value) {
        if (value instanceof Map) {
            this.visit((Map)value);
        } else if (value instanceof List) {
            this.visit((List)value);
        }
    }

    protected Map<String, Object> parseQuery(byte[] source) {
        return this.parseQuery((BytesReference)new BytesArray(source, 0, source.length));
    }

    protected Map<String, Object> parseQuery(String source) {
        try {
            byte[] bytes = Base64.decode((String)source);
            return this.parseQuery((BytesReference)new BytesArray(bytes, 0, bytes.length));
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse source [" + source + "]", (Throwable)e, new Object[0]);
        }
    }

    protected Map<String, Object> parseQuery(BytesReference source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        try {
            Tuple parsedSource = XContentHelper.convertToMap((BytesReference)source, (boolean)false);
            return (Map)parsedSource.v2();
        }
        catch (Throwable e) {
            String sSource = "_na_";
            try {
                sSource = XContentHelper.convertToJson((BytesReference)source, (boolean)false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ElasticsearchParseException("Failed to parse source [" + sSource + "]", e, new Object[0]);
        }
    }
}

