/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.execution;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import solutions.siren.join.action.coordinate.model.AbstractNode;
import solutions.siren.join.action.coordinate.model.FilterJoinNode;
import solutions.siren.join.action.coordinate.model.RootNode;

public class SourceMapVisitor {
    private final RootNode root;
    private Deque<AbstractNode> queue = new LinkedList<AbstractNode>();

    public SourceMapVisitor(Map map) {
        this.root = new RootNode(map);
        this.queue.offer(this.root);
    }

    public RootNode getFilterJoinTree() {
        return this.root;
    }

    public void traverse() {
        this.visit(this.root.getSourceMap());
    }

    private void visit(Map map) {
        Set entries = map.entrySet();
        if (map.containsKey("filterjoin")) {
            FilterJoinNode node = new FilterJoinNode(map, (Map)map.get("filterjoin"));
            this.queue.peek().addChild(node);
            this.queue.addFirst(node);
        }
        for (Map.Entry entry : entries) {
            this.visit(entry.getValue());
        }
        if (map.containsKey("filterjoin")) {
            this.queue.poll();
        }
    }

    private void visit(List array) {
        for (Object obj : array) {
            this.visit(obj);
        }
    }

    private void visit(Object value) {
        if (value instanceof Map) {
            this.visit((Map)value);
        } else if (value instanceof List) {
            this.visit((List)value);
        }
    }
}

