/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.execution;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.coordinate.execution.CoordinateSearchMetadata;
import solutions.siren.join.action.coordinate.execution.FilterJoinCache;
import solutions.siren.join.action.coordinate.model.AbstractNode;
import solutions.siren.join.action.coordinate.model.FilterJoinNode;
import solutions.siren.join.action.coordinate.model.FilterJoinTerms;
import solutions.siren.join.action.coordinate.model.RootNode;
import solutions.siren.join.action.coordinate.pipeline.NodePipelineListener;
import solutions.siren.join.action.coordinate.pipeline.NodePipelineManager;
import solutions.siren.join.action.coordinate.pipeline.NodeTaskContext;
import solutions.siren.join.action.coordinate.tasks.CacheLookupTask;
import solutions.siren.join.action.coordinate.tasks.CardinalityEstimationTask;
import solutions.siren.join.action.coordinate.tasks.IndicesVersionTask;
import solutions.siren.join.action.coordinate.tasks.TermsByQueryTask;
import solutions.siren.join.action.terms.TermsByQueryRequest;

public class FilterJoinVisitor {
    protected final ActionRequest parentRequest;
    private final RootNode root;
    protected final Client client;
    protected final BlockingQueue<Integer> blockingQueue = new LinkedBlockingQueue<Integer>();
    protected final CoordinateSearchMetadata metadata;
    private final FilterJoinCache cache;
    private static final ESLogger logger = Loggers.getLogger(FilterJoinVisitor.class);

    public FilterJoinVisitor(Client client, RootNode root, FilterJoinCache cache, ActionRequest parentRequest) {
        this.parentRequest = parentRequest;
        this.client = client;
        this.root = root;
        this.cache = cache;
        this.metadata = new CoordinateSearchMetadata();
    }

    public void unblock() {
        this.blockingQueue.offer(0);
    }

    public FilterJoinCache getCache() {
        return this.cache;
    }

    public ActionRequest getParentRequest() {
        return this.parentRequest;
    }

    public CoordinateSearchMetadata getMetadata() {
        return this.metadata;
    }

    public void traverse() {
        while (this.root.hasChildren()) {
            this.visit(this.root);
            this.await();
        }
    }

    private void await() {
        try {
            boolean nodeRemoved = this.removeConvertedNodes(this.root);
            if (!nodeRemoved && this.root.hasChildren()) {
                logger.debug("Visitor thread block - blocking queue size: {}", new Object[]{this.blockingQueue.size()});
                this.blockingQueue.take();
                this.blockingQueue.offer(0);
                logger.debug("Visitor thread unblock - blocking queue size: {}", new Object[]{this.blockingQueue.size()});
            }
        }
        catch (InterruptedException e) {
            logger.warn("Filter join visitor thread interrupted while waiting", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private boolean removeConvertedNodes(AbstractNode node) {
        boolean nodeRemoved = false;
        Iterator<AbstractNode> it = node.getChildren().iterator();
        while (it.hasNext()) {
            FilterJoinNode child = (FilterJoinNode)it.next();
            if (child.getState().equals((Object)FilterJoinNode.State.CONVERTED)) {
                it.remove();
                nodeRemoved |= true;
                continue;
            }
            nodeRemoved |= this.removeConvertedNodes(child);
        }
        return nodeRemoved;
    }

    private void visit(RootNode root) {
        for (AbstractNode child : root.getChildren()) {
            this.visit((FilterJoinNode)child, null);
        }
    }

    private void visit(FilterJoinNode node, FilterJoinNode parent) {
        if (node.hasChildren()) {
            for (AbstractNode child : node.getChildren()) {
                this.visit((FilterJoinNode)child, node);
            }
        } else {
            this.visitLeafNode(node, parent);
        }
    }

    private void visitLeafNode(FilterJoinNode node, FilterJoinNode parent) {
        switch (node.getState()) {
            case WAITING: {
                this.executeAsyncOperation(node);
                return;
            }
            case COMPLETED: {
                this.checkForFailure(node);
                this.recordMetadata(node, parent);
                this.convertToTermsQuery(node);
                return;
            }
        }
    }

    protected void executeAsyncOperation(final FilterJoinNode node) {
        logger.debug("Executing async actions", new Object[0]);
        node.setState(FilterJoinNode.State.RUNNING);
        NodePipelineManager pipeline = new NodePipelineManager();
        pipeline.addListener(new NodePipelineListener(){

            @Override
            public void onSuccess() {
                node.setState(FilterJoinNode.State.COMPLETED);
                FilterJoinVisitor.this.unblock();
            }

            @Override
            public void onFailure(Throwable e) {
                node.setFailure(e);
                node.setState(FilterJoinNode.State.COMPLETED);
                FilterJoinVisitor.this.unblock();
            }
        });
        pipeline.addTask(new IndicesVersionTask());
        pipeline.addTask(new CacheLookupTask());
        pipeline.addTask(new CardinalityEstimationTask());
        pipeline.addTask(new TermsByQueryTask());
        pipeline.execute(new NodeTaskContext(this.client, node, this));
    }

    protected CoordinateSearchMetadata.Action recordMetadata(FilterJoinNode node, FilterJoinNode parent) {
        FilterJoinTerms terms = node.getTerms();
        String[] fromIndices = node.getLookupIndices();
        String[] fromTypes = node.getLookupTypes();
        String[] toIndices = parent == null ? null : parent.getLookupIndices();
        String[] toTypes = parent == null ? null : parent.getLookupTypes();
        CoordinateSearchMetadata.Relation from = new CoordinateSearchMetadata.Relation(fromIndices, fromTypes, node.getLookupPath());
        CoordinateSearchMetadata.Relation to = new CoordinateSearchMetadata.Relation(toIndices, toTypes, node.getField());
        CoordinateSearchMetadata.Action action = this.metadata.addAction(from, to);
        action.setPruned(terms.isPruned());
        action.setSize(terms.getSize());
        action.setSizeInBytes(terms.getEncodedTerms().length);
        action.setCacheHit(terms.cacheHit());
        action.setTookInMillis(terms.getTookInMillis());
        action.setTermsEncoding(node.getTermsEncoding());
        action.setOrdering(node.getOrderBy());
        action.setMaxTermsPerShard(node.getMaxTermsPerShard());
        return action;
    }

    private void checkForFailure(FilterJoinNode node) {
        if (node.hasFailure()) {
            logger.error("Node processing failed: {}", node.getFailure(), new Object[0]);
            throw new ElasticsearchException("Unexpected failure while processing a node", node.getFailure(), new Object[0]);
        }
    }

    private void convertToTermsQuery(FilterJoinNode node) {
        Map<String, Object> parent = node.getParentSourceMap();
        FilterJoinTerms terms = node.getTerms();
        BytesRef bytes = terms.getEncodedTerms();
        parent.remove("filterjoin");
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("value", bytes.bytes);
        queryParams.put("_cache_key", node.getCacheId());
        HashMap<String, HashMap<String, Object>> field = new HashMap<String, HashMap<String, Object>>();
        field.put(node.getField(), queryParams);
        HashMap<String, HashMap<String, HashMap<String, Object>>> termsQuery = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        if (node.getTermsEncoding().equals((Object)TermsByQueryRequest.TermsEncoding.BYTES)) {
            termsQuery.put("termsenum_terms", field);
        } else {
            termsQuery.put("fielddata_terms", field);
        }
        HashMap<String, HashMap<String, HashMap<String, HashMap<String, Object>>>> constantScoreQueryParams = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, Object>>>>();
        constantScoreQueryParams.put("filter", termsQuery);
        parent.put("constant_score", constantScoreQueryParams);
        node.setState(FilterJoinNode.State.CONVERTED);
        this.blockingQueue.poll();
    }
}

