/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.execution;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.Weigher;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import solutions.siren.join.action.coordinate.model.FilterJoinTerms;

public class FilterJoinCache {
    private final Cache<Long, CacheEntry> cache;
    private static final int DEFAULT_CACHE_SIZE = 0x10000000;
    public static final String SIREN_FILTERJOIN_CACHE_ENABLED = "siren.filterjoin.cache.enabled";
    public static final String SIREN_FILTERJOIN_CACHE_SIZE = "siren.filterjoin.cache.size";
    private static final ESLogger logger = Loggers.getLogger(FilterJoinCache.class);

    public FilterJoinCache(Settings settings) {
        boolean isEnabled = settings.getAsBoolean(SIREN_FILTERJOIN_CACHE_ENABLED, Boolean.valueOf(true));
        long size = settings.getAsInt(SIREN_FILTERJOIN_CACHE_SIZE, Integer.valueOf(0x10000000)).intValue();
        this.cache = isEnabled ? CacheBuilder.newBuilder().recordStats().maximumWeight(size).weigher((Weigher)new CacheEntryWeigher()).build() : CacheBuilder.newBuilder().maximumSize(0L).build();
    }

    public void put(long cacheKey, FilterJoinTerms terms) {
        logger.debug("{}: New cache entry {}", new Object[]{Thread.currentThread().getName(), cacheKey});
        this.cache.put((Object)cacheKey, (Object)new CacheEntry(terms.getEncodedTerms(), terms.getSize(), terms.isPruned()));
    }

    public CacheEntry get(long cacheKey) {
        CacheEntry entry = (CacheEntry)this.cache.getIfPresent((Object)cacheKey);
        return entry;
    }

    public void invalidateAll() {
        logger.debug("{}: Invalidate all cache entries", new Object[]{Thread.currentThread().getName()});
        this.cache.invalidateAll();
    }

    public FilterJoinCacheStats getStats() {
        return new FilterJoinCacheStats(this.cache.size(), this.cache.stats());
    }

    public long getSize() {
        return this.cache.size();
    }

    public static class FilterJoinCacheStats
    implements Streamable {
        private CacheStats cacheStats;
        private long size;

        public FilterJoinCacheStats() {
        }

        public FilterJoinCacheStats(long size, CacheStats stats) {
            this.cacheStats = stats;
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public CacheStats getCacheStats() {
            return this.cacheStats;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.size = in.readVLong();
            long hitCount = in.readVLong();
            long misscount = in.readVLong();
            long loadSuccessCount = in.readVLong();
            long loadExceptionCount = in.readVLong();
            long totalLoadTime = in.readVLong();
            long evictionCount = in.readVLong();
            this.cacheStats = new CacheStats(hitCount, misscount, loadSuccessCount, loadExceptionCount, totalLoadTime, evictionCount);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.size);
            out.writeVLong(this.cacheStats.hitCount());
            out.writeVLong(this.cacheStats.missCount());
            out.writeVLong(this.cacheStats.loadSuccessCount());
            out.writeVLong(this.cacheStats.loadExceptionCount());
            out.writeVLong(this.cacheStats.totalLoadTime());
            out.writeVLong(this.cacheStats.evictionCount());
        }
    }

    static class CacheEntryWeigher
    implements Weigher<Long, CacheEntry> {
        CacheEntryWeigher() {
        }

        public int weigh(Long key, CacheEntry value) {
            return value.encodedTerms.length;
        }
    }

    public static class CacheEntry {
        public final BytesRef encodedTerms;
        public final int size;
        public final boolean isPruned;

        private CacheEntry(BytesRef encodedTerms, int size, boolean isPruned) {
            this.encodedTerms = encodedTerms;
            this.size = size;
            this.isPruned = isPruned;
        }
    }
}

