/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import solutions.siren.join.action.terms.TermsByQueryRequest;

public class CoordinateSearchMetadata {
    private List<Action> actions = new ArrayList<Action>();

    Action addAction(Relation from, Relation to) {
        Action action = new Action(from, to);
        this.actions.add(action);
        return action;
    }

    List<Action> getActions() {
        return this.actions;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        builder.startObject(Fields.COORDINATE_SEARCH);
        builder.startArray(Fields.ACTIONS);
        for (Action action : this.actions) {
            action.toXContent(builder);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            Action action = new Action();
            action.readFrom(in);
            this.actions.add(action);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.actions.size());
        for (Action action : this.actions) {
            action.writeTo(out);
        }
    }

    static class Relation {
        String[] indices;
        String[] types;
        String field;

        Relation() {
        }

        Relation(String[] indices, String[] types, String field) {
            this.indices = indices;
            this.types = types;
            this.field = field;
        }

        public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
            if (this.indices != null) {
                builder.field(Fields.INDICES, this.indices);
            } else {
                builder.nullField(Fields.INDICES);
            }
            if (this.types != null) {
                builder.field(Fields.TYPES, this.types);
            } else {
                builder.nullField(Fields.TYPES);
            }
            builder.field(Fields.FIELD, this.field);
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.types = in.readStringArray();
            this.field = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArrayNullable(this.indices);
            out.writeStringArrayNullable(this.types);
            out.writeOptionalString(this.field);
        }

        static final class Fields {
            static final XContentBuilderString INDICES = new XContentBuilderString("indices");
            static final XContentBuilderString TYPES = new XContentBuilderString("types");
            static final XContentBuilderString FIELD = new XContentBuilderString("field");

            Fields() {
            }
        }
    }

    static class Action {
        Relation[] relations;
        int size;
        long sizeInBytes;
        boolean isPruned;
        boolean cacheHit;
        long tookInMillis;
        TermsByQueryRequest.TermsEncoding termsEncoding;
        TermsByQueryRequest.Ordering ordering;
        int maxTermsPerShard;

        Action() {
        }

        Action(Relation from, Relation to) {
            this.relations = new Relation[]{from, to};
        }

        void setPruned(boolean isPruned) {
            this.isPruned = isPruned;
        }

        void setSize(int size) {
            this.size = size;
        }

        void setSizeInBytes(long size) {
            this.sizeInBytes = size;
        }

        void setCacheHit(boolean cacheHit) {
            this.cacheHit = cacheHit;
        }

        void setTookInMillis(long tookInMillis) {
            this.tookInMillis = tookInMillis;
        }

        void setTermsEncoding(TermsByQueryRequest.TermsEncoding termsEncoding) {
            this.termsEncoding = termsEncoding;
        }

        public void setMaxTermsPerShard(Integer maxTermsPerShard) {
            this.maxTermsPerShard = maxTermsPerShard == null ? -1 : maxTermsPerShard;
        }

        public void setOrdering(TermsByQueryRequest.Ordering ordering) {
            this.ordering = ordering;
        }

        public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
            builder.startObject();
            builder.startObject(Fields.RELATIONS);
            builder.startObject(Fields.FROM);
            this.relations[0].toXContent(builder);
            builder.endObject();
            builder.startObject(Fields.TO);
            this.relations[1].toXContent(builder);
            builder.endObject();
            builder.endObject();
            builder.field(Fields.SIZE, this.size);
            builder.field(Fields.SIZE_IN_BYTES, this.sizeInBytes);
            builder.field(Fields.IS_PRUNED, this.isPruned);
            builder.field(Fields.CACHE_HIT, this.cacheHit);
            builder.field(Fields.TERMS_ENCODING, this.termsEncoding.name().toLowerCase(Locale.ROOT));
            if (this.ordering != null) {
                builder.field(Fields.ORDERING, this.ordering.name().toLowerCase(Locale.ROOT));
            }
            if (this.maxTermsPerShard != -1) {
                builder.field(Fields.MAX_TERMS_PER_SHARD, this.maxTermsPerShard);
            }
            builder.field(Fields.TOOK, this.tookInMillis);
            builder.endObject();
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            Relation left = new Relation();
            left.readFrom(in);
            Relation right = new Relation();
            right.readFrom(in);
            this.relations = new Relation[]{left, right};
            this.size = in.readVInt();
            this.sizeInBytes = in.readVLong();
            this.isPruned = in.readBoolean();
            this.cacheHit = in.readBoolean();
            this.tookInMillis = in.readLong();
            this.termsEncoding = TermsByQueryRequest.TermsEncoding.values()[in.readVInt()];
            if (in.readBoolean()) {
                this.ordering = TermsByQueryRequest.Ordering.values()[in.readVInt()];
            }
            if (in.readBoolean()) {
                this.maxTermsPerShard = in.readVInt();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.relations[0].writeTo(out);
            this.relations[1].writeTo(out);
            out.writeVInt(this.size);
            out.writeVLong(this.sizeInBytes);
            out.writeBoolean(this.isPruned);
            out.writeBoolean(this.cacheHit);
            out.writeLong(this.tookInMillis);
            out.writeVInt(this.termsEncoding.ordinal());
            if (this.ordering == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeVInt(this.ordering.ordinal());
            }
            if (this.maxTermsPerShard == -1) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeVInt(this.maxTermsPerShard);
            }
        }

        static final class Fields {
            static final XContentBuilderString RELATIONS = new XContentBuilderString("relations");
            static final XContentBuilderString FROM = new XContentBuilderString("from");
            static final XContentBuilderString TO = new XContentBuilderString("to");
            static final XContentBuilderString SIZE = new XContentBuilderString("size");
            static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
            static final XContentBuilderString IS_PRUNED = new XContentBuilderString("is_pruned");
            static final XContentBuilderString CACHE_HIT = new XContentBuilderString("cache_hit");
            static final XContentBuilderString TOOK = new XContentBuilderString("took");
            static final XContentBuilderString TERMS_ENCODING = new XContentBuilderString("terms_encoding");
            static final XContentBuilderString ORDERING = new XContentBuilderString("order_by");
            static final XContentBuilderString MAX_TERMS_PER_SHARD = new XContentBuilderString("max_terms_per_shard");

            Fields() {
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString COORDINATE_SEARCH = new XContentBuilderString("coordinate_search");
        static final XContentBuilderString ACTIONS = new XContentBuilderString("actions");

        Fields() {
        }
    }
}

