/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.admin.cache.FilterJoinCacheService;
import solutions.siren.join.action.coordinate.BaseTransportCoordinateSearchAction;
import solutions.siren.join.action.coordinate.CoordinateSearchResponse;
import solutions.siren.join.action.coordinate.execution.CoordinateSearchMetadata;
import solutions.siren.join.action.coordinate.execution.FilterJoinCache;
import solutions.siren.join.action.coordinate.execution.FilterJoinVisitor;
import solutions.siren.join.action.coordinate.execution.SourceMapVisitor;
import solutions.siren.join.action.coordinate.execution.WrapperQueryVisitor;

public class TransportCoordinateSearchAction
extends BaseTransportCoordinateSearchAction<SearchRequest, SearchResponse> {
    private final TransportSearchAction searchAction;
    private final FilterJoinCacheService cacheService;

    @Inject
    public TransportCoordinateSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, FilterJoinCacheService cacheService, ActionFilters actionFilters, TransportSearchAction searchAction, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "indices:data/read/coordinate-search", threadPool, transportService, actionFilters, indexNameExpressionResolver, client, SearchRequest.class);
        this.searchAction = searchAction;
        this.cacheService = cacheService;
    }

    protected void doExecute(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.logger.debug("{}: Execute coordinated search action", new Object[]{Thread.currentThread().getName()});
        CoordinateSearchListener actionListener = listener;
        FilterJoinCache cache = this.cacheService.getCacheInstance();
        Tuple<XContentType, Map<String, Object>> parsedSource = this.parseSource(request.source());
        if (parsedSource != null) {
            Map map = (Map)parsedSource.v2();
            WrapperQueryVisitor wrapperVisitor = new WrapperQueryVisitor(map);
            wrapperVisitor.traverse();
            SourceMapVisitor mapVisitor = new SourceMapVisitor(map);
            mapVisitor.traverse();
            FilterJoinVisitor joinVisitor = new FilterJoinVisitor(this.client, mapVisitor.getFilterJoinTree(), cache, (ActionRequest)request);
            joinVisitor.traverse();
            CoordinateSearchListener coordinateSearchListener = new CoordinateSearchListener(listener);
            coordinateSearchListener.setMetadata(joinVisitor.getMetadata());
            actionListener = coordinateSearchListener;
            request.source(this.buildSource(((XContentType)parsedSource.v1()).xContent(), map));
        }
        this.searchAction.execute((ActionRequest)request, actionListener);
        this.logger.debug("{}: Coordinated search action completed", new Object[]{Thread.currentThread().getName()});
    }

    public static class CoordinateSearchListener
    implements ActionListener<SearchResponse> {
        private final ActionListener<SearchResponse> actionListener;
        private CoordinateSearchMetadata metadata;

        public CoordinateSearchListener(ActionListener<SearchResponse> listener) {
            this.actionListener = listener;
        }

        public void setMetadata(CoordinateSearchMetadata metadata) {
            this.metadata = metadata;
        }

        public final void onResponse(SearchResponse response) {
            CoordinateSearchResponse r = new CoordinateSearchResponse(response, this.metadata);
            this.actionListener.onResponse((Object)r);
        }

        public final void onFailure(Throwable e) {
            this.actionListener.onFailure(e);
        }
    }
}

