/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.admin.cache.FilterJoinCacheService;
import solutions.siren.join.action.coordinate.BaseTransportCoordinateSearchAction;
import solutions.siren.join.action.coordinate.CoordinateMultiSearchResponse;
import solutions.siren.join.action.coordinate.CoordinateSearchResponse;
import solutions.siren.join.action.coordinate.execution.CoordinateSearchMetadata;
import solutions.siren.join.action.coordinate.execution.FilterJoinCache;
import solutions.siren.join.action.coordinate.execution.FilterJoinVisitor;
import solutions.siren.join.action.coordinate.execution.SourceMapVisitor;
import solutions.siren.join.action.coordinate.execution.WrapperQueryVisitor;

public class TransportCoordinateMultiSearchAction
extends BaseTransportCoordinateSearchAction<MultiSearchRequest, MultiSearchResponse> {
    private final ClusterService clusterService;
    private final TransportSearchAction searchAction;
    private final FilterJoinCacheService cacheService;

    @Inject
    public TransportCoordinateMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, FilterJoinCacheService cacheService, TransportSearchAction search, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "indices:data/read/coordinate-msearch", threadPool, transportService, actionFilters, indexNameExpressionResolver, client, MultiSearchRequest.class);
        this.searchAction = search;
        this.clusterService = clusterService;
        this.cacheService = cacheService;
    }

    protected void doExecute(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.logger.debug("{}: Execute coordinated multi-search action", new Object[]{Thread.currentThread().getName()});
        ArrayList<CoordinateSearchMetadata> metadatas = new ArrayList<CoordinateSearchMetadata>(request.requests().size());
        this.doExecuteFilterJoins(request, metadatas);
        this.doExecuteRequest(request, listener, metadatas);
        this.logger.debug("{}: Coordinated multi-search action completed", new Object[]{Thread.currentThread().getName()});
    }

    private void doExecuteFilterJoins(MultiSearchRequest request, List<CoordinateSearchMetadata> metadatas) {
        FilterJoinCache cache = this.cacheService.getCacheInstance();
        for (int i = 0; i < request.requests().size(); ++i) {
            Tuple<XContentType, Map<String, Object>> parsedSource = this.parseSource(((SearchRequest)request.requests().get(i)).source());
            Map map = (Map)parsedSource.v2();
            WrapperQueryVisitor wrapperVisitor = new WrapperQueryVisitor(map);
            wrapperVisitor.traverse();
            SourceMapVisitor mapVisitor = new SourceMapVisitor(map);
            mapVisitor.traverse();
            FilterJoinVisitor joinVisitor = new FilterJoinVisitor(this.client, mapVisitor.getFilterJoinTree(), cache, (ActionRequest)request);
            joinVisitor.traverse();
            metadatas.add(joinVisitor.getMetadata());
            ((SearchRequest)request.requests().get(i)).source(this.buildSource(((XContentType)parsedSource.v1()).xContent(), map));
        }
    }

    private void doExecuteRequest(MultiSearchRequest request, final ActionListener<MultiSearchResponse> listener, final List<CoordinateSearchMetadata> metadatas) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray responses = new AtomicArray(request.requests().size());
        final AtomicInteger counter = new AtomicInteger(responses.length());
        for (int i = 0; i < responses.length(); ++i) {
            final int index = i;
            SearchRequest searchRequest = new SearchRequest((SearchRequest)request.requests().get(i), (ActionRequest)request);
            this.searchAction.execute((ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    responses.set(index, (Object)new CoordinateMultiSearchResponse.Item(new CoordinateSearchResponse(searchResponse, (CoordinateSearchMetadata)metadatas.get(index)), null));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                public void onFailure(Throwable e) {
                    responses.set(index, (Object)new CoordinateMultiSearchResponse.Item(null, ExceptionsHelper.detailedMessage((Throwable)e)));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse((Object)new CoordinateMultiSearchResponse((CoordinateMultiSearchResponse.Item[])responses.toArray((Object[])new CoordinateMultiSearchResponse.Item[responses.length()])));
                }
            });
        }
    }
}

