/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import solutions.siren.join.action.coordinate.CoordinateSearchResponse;

public class CoordinateMultiSearchResponse
extends MultiSearchResponse {
    private Item[] items;

    CoordinateMultiSearchResponse() {
        super(new MultiSearchResponse.Item[0]);
    }

    public CoordinateMultiSearchResponse(Item[] items) {
        super(new MultiSearchResponse.Item[0]);
        this.items = items;
    }

    public Iterator<MultiSearchResponse.Item> iterator() {
        return Iterators.forArray((Object[])this.items);
    }

    public Item[] getResponses() {
        return this.items;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = Item.readItem(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.RESPONSES);
        for (Item item : this.items) {
            if (item.isFailure()) {
                builder.startObject();
                builder.field(Fields.ERROR, item.getFailureMessage());
                builder.endObject();
                continue;
            }
            builder.startObject();
            item.getResponse().toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString RESPONSES = new XContentBuilderString("responses");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");

        Fields() {
        }
    }

    public static class Item
    extends MultiSearchResponse.Item {
        private SearchResponse response;
        private String failureMessage;

        Item() {
            super(null, null);
        }

        public Item(SearchResponse response, String failureMessage) {
            super(null, null);
            this.response = response;
            this.failureMessage = failureMessage;
        }

        public boolean isFailure() {
            return this.failureMessage != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.failureMessage;
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new CoordinateSearchResponse();
                this.response.readFrom(in);
            } else {
                this.failureMessage = in.readString();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeString(this.failureMessage);
            }
        }
    }
}

