/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.coordinate;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public abstract class BaseTransportCoordinateSearchAction<Request extends ActionRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final Client client;

    protected BaseTransportCoordinateSearchAction(Settings settings, String actionName, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, Class<Request> request) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, request, "generic", (TransportRequestHandler)new TransportHandler());
        this.client = client;
    }

    protected Tuple<XContentType, Map<String, Object>> parseSource(BytesReference source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        try {
            Tuple parsedSource = XContentHelper.convertToMap((BytesReference)source, (boolean)false);
            this.logger.debug("{}: Parsed source: {}", new Object[]{Thread.currentThread().getName(), parsedSource});
            return parsedSource;
        }
        catch (Throwable e) {
            String sSource = "_na_";
            try {
                sSource = XContentHelper.convertToJson((BytesReference)source, (boolean)false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ElasticsearchParseException("Failed to parse source [" + sSource + "]", e, new Object[0]);
        }
    }

    protected XContentBuilder buildSource(XContent content, Map<String, Object> map) {
        try {
            return XContentBuilder.builder((XContent)XContentType.CBOR.xContent()).map(map);
        }
        catch (IOException e) {
            this.logger.error("failed to build source", (Throwable)e, new Object[0]);
            throw new IllegalStateException("Failed to build source", e);
        }
    }

    class TransportHandler
    extends TransportRequestHandler<Request> {
        TransportHandler() {
        }

        public final void messageReceived(Request request, final TransportChannel channel) throws Exception {
            BaseTransportCoordinateSearchAction.this.execute((ActionRequest)request, new ActionListener<Response>((ActionRequest)request){
                final /* synthetic */ ActionRequest val$request;
                {
                    this.val$request = actionRequest;
                }

                public void onResponse(Response response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        BaseTransportCoordinateSearchAction.this.logger.warn("Failed to send error response for action [{}] and request [{}]", (Throwable)e1, new Object[]{BaseTransportCoordinateSearchAction.this.actionName, this.val$request});
                    }
                }
            });
        }
    }
}

