/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.version;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.admin.version.GetIndicesVersionRequest;
import solutions.siren.join.action.admin.version.GetIndicesVersionResponse;
import solutions.siren.join.action.admin.version.IndexVersionShardService;
import solutions.siren.join.action.admin.version.ShardIndexVersion;

public class TransportGetIndicesVersionAction
extends TransportBroadcastByNodeAction<GetIndicesVersionRequest, GetIndicesVersionResponse, ShardIndexVersion> {
    private final IndicesService indicesService;

    @Inject
    public TransportGetIndicesVersionAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/version/get", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetIndicesVersionRequest.class, "management");
        this.indicesService = indicesService;
    }

    protected ShardIndexVersion readShardResult(StreamInput in) throws IOException {
        return ShardIndexVersion.readShardIndexVersion(in);
    }

    protected GetIndicesVersionResponse newResponse(GetIndicesVersionRequest request, int totalShards, int successfulShards, int failedShards, List<ShardIndexVersion> shardVersions, List<ShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new GetIndicesVersionResponse(shardVersions.toArray(new ShardIndexVersion[shardVersions.size()]), totalShards, successfulShards, failedShards, shardFailures);
    }

    protected GetIndicesVersionRequest readRequestFrom(StreamInput in) throws IOException {
        GetIndicesVersionRequest request = new GetIndicesVersionRequest();
        request.readFrom(in);
        return request;
    }

    protected ShardIndexVersion shardOperation(GetIndicesVersionRequest request, ShardRouting shardRouting) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardRouting.id());
        Injector injector = indexService.shardInjectorSafe(shardRouting.id());
        IndexVersionShardService indexVersionService = (IndexVersionShardService)injector.getBinding(IndexVersionShardService.class).getProvider().get();
        long version = indexVersionService.getVersion();
        return new ShardIndexVersion(indexShard.routingEntry(), version);
    }

    protected ShardsIterator shards(ClusterState clusterState, GetIndicesVersionRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, GetIndicesVersionRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, GetIndicesVersionRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

