/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.version;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

public class IndexVersionShardService
extends AbstractIndexShardComponent
implements Closeable {
    private final AtomicLong version;
    private final IndexShard indexShard;
    private final VersioningIndexingOperationListener versioningIndexingOperationListener;

    @Inject
    public IndexVersionShardService(ShardId shardId, Settings indexSettings, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = indexShard;
        this.versioningIndexingOperationListener = new VersioningIndexingOperationListener();
        indexShard.indexingService().addListener((IndexingOperationListener)this.versioningIndexingOperationListener);
        this.version = new AtomicLong(System.nanoTime());
    }

    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void close() {
        this.indexShard.indexingService().removeListener((IndexingOperationListener)this.versioningIndexingOperationListener);
    }

    private class VersioningIndexingOperationListener
    extends IndexingOperationListener {
        private VersioningIndexingOperationListener() {
        }

        public void postIndexUnderLock(Engine.Index index) {
            IndexVersionShardService.this.version.incrementAndGet();
        }

        public void postDeleteUnderLock(Engine.Delete delete) {
            IndexVersionShardService.this.version.incrementAndGet();
        }
    }
}

