/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.version;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import solutions.siren.join.action.admin.version.ShardIndexVersion;

public class GetIndicesVersionResponse
extends BroadcastResponse {
    private ShardIndexVersion[] shards;
    private Map<String, Long> indicesVersions;

    GetIndicesVersionResponse() {
    }

    GetIndicesVersionResponse(ShardIndexVersion[] shards, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public long getVersion() {
        long version = 1L;
        ArrayList<String> indices = new ArrayList<String>(this.getIndices().keySet());
        Collections.sort(indices);
        for (String index : indices) {
            version = 31L * version + this.getIndices().get(index);
        }
        return version;
    }

    public Map<String, Long> getIndices() {
        if (this.indicesVersions != null) {
            return this.indicesVersions;
        }
        HashMap indicesVersions = Maps.newHashMap();
        HashSet indices = Sets.newHashSet();
        for (ShardIndexVersion shard : this.shards) {
            indices.add(shard.getShardRouting().getIndex());
        }
        for (String index : indices) {
            ArrayList<ShardIndexVersion> shards = new ArrayList<ShardIndexVersion>();
            for (ShardIndexVersion shard : this.shards) {
                if (!shard.getShardRouting().index().equals(index)) continue;
                shards.add(shard);
            }
            indicesVersions.put(index, this.getIndexVersion(shards));
        }
        this.indicesVersions = indicesVersions;
        return indicesVersions;
    }

    private long getIndexVersion(List<ShardIndexVersion> shards) {
        long version = 1L;
        Collections.sort(shards, new Comparator<ShardIndexVersion>(){

            @Override
            public int compare(ShardIndexVersion o1, ShardIndexVersion o2) {
                return o1.getShardRouting().id() - o2.getShardRouting().id();
            }
        });
        for (ShardIndexVersion shard : shards) {
            version = 31L * version + shard.getVersion();
        }
        return version;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardIndexVersion[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ShardIndexVersion.readShardIndexVersion(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardIndexVersion shard : this.shards) {
            shard.writeTo(out);
        }
    }
}

