/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.cache;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.admin.cache.FilterJoinCacheService;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheNodeRequest;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheNodeResponse;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheRequest;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheResponse;

public class TransportStatsFilterJoinCacheAction
extends TransportNodesAction<StatsFilterJoinCacheRequest, StatsFilterJoinCacheResponse, StatsFilterJoinCacheNodeRequest, StatsFilterJoinCacheNodeResponse> {
    private final ClusterService clusterService;
    private final FilterJoinCacheService cacheService;

    @Inject
    public TransportStatsFilterJoinCacheAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, FilterJoinCacheService cacheService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/filterjoin/cache/stats", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, StatsFilterJoinCacheRequest.class, StatsFilterJoinCacheNodeRequest.class, "management");
        this.cacheService = cacheService;
        this.clusterService = clusterService;
    }

    protected StatsFilterJoinCacheResponse newResponse(StatsFilterJoinCacheRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList<StatsFilterJoinCacheNodeResponse> nodeStats = new ArrayList<StatsFilterJoinCacheNodeResponse>();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object resp = nodesResponses.get(i);
            if (!(resp instanceof StatsFilterJoinCacheNodeResponse)) continue;
            nodeStats.add((StatsFilterJoinCacheNodeResponse)((Object)resp));
        }
        return new StatsFilterJoinCacheResponse(this.clusterName, nodeStats.toArray(new StatsFilterJoinCacheNodeResponse[nodeStats.size()]));
    }

    protected StatsFilterJoinCacheNodeRequest newNodeRequest(String nodeId, StatsFilterJoinCacheRequest request) {
        return new StatsFilterJoinCacheNodeRequest(nodeId, request);
    }

    protected StatsFilterJoinCacheNodeResponse newNodeResponse() {
        return new StatsFilterJoinCacheNodeResponse();
    }

    protected StatsFilterJoinCacheNodeResponse nodeOperation(StatsFilterJoinCacheNodeRequest request) {
        this.logger.debug("Clearing filter join cache on node {}", new Object[]{this.clusterService.localNode()});
        return new StatsFilterJoinCacheNodeResponse(this.clusterService.localNode(), System.currentTimeMillis(), this.cacheService.getStats());
    }

    protected boolean accumulateExceptions() {
        return false;
    }
}

