/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.cache;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import solutions.siren.join.action.admin.cache.ClearFilterJoinCacheNodeRequest;
import solutions.siren.join.action.admin.cache.ClearFilterJoinCacheNodeResponse;
import solutions.siren.join.action.admin.cache.ClearFilterJoinCacheRequest;
import solutions.siren.join.action.admin.cache.ClearFilterJoinCacheResponse;
import solutions.siren.join.action.admin.cache.FilterJoinCacheService;

public class TransportClearFilterJoinCacheAction
extends TransportNodesAction<ClearFilterJoinCacheRequest, ClearFilterJoinCacheResponse, ClearFilterJoinCacheNodeRequest, ClearFilterJoinCacheNodeResponse> {
    private final ClusterService clusterService;
    private final FilterJoinCacheService cacheService;

    @Inject
    public TransportClearFilterJoinCacheAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, FilterJoinCacheService cacheService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/filterjoin/cache/clear", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearFilterJoinCacheRequest.class, ClearFilterJoinCacheNodeRequest.class, "management");
        this.cacheService = cacheService;
        this.clusterService = clusterService;
    }

    protected ClearFilterJoinCacheResponse newResponse(ClearFilterJoinCacheRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList<ClearFilterJoinCacheNodeResponse> nodes = new ArrayList<ClearFilterJoinCacheNodeResponse>();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object resp = nodesResponses.get(i);
            if (!(resp instanceof ClearFilterJoinCacheNodeResponse)) continue;
            nodes.add((ClearFilterJoinCacheNodeResponse)((Object)resp));
        }
        return new ClearFilterJoinCacheResponse(this.clusterName, nodes.toArray(new ClearFilterJoinCacheNodeResponse[nodes.size()]));
    }

    protected ClearFilterJoinCacheNodeRequest newNodeRequest(String nodeId, ClearFilterJoinCacheRequest request) {
        return new ClearFilterJoinCacheNodeRequest(nodeId, request);
    }

    protected ClearFilterJoinCacheNodeResponse newNodeResponse() {
        return new ClearFilterJoinCacheNodeResponse();
    }

    protected ClearFilterJoinCacheNodeResponse nodeOperation(ClearFilterJoinCacheNodeRequest request) {
        this.logger.debug("Clearing filter join cache on node {}", new Object[]{this.clusterService.localNode()});
        this.cacheService.clear();
        return new ClearFilterJoinCacheNodeResponse(this.clusterService.localNode(), System.currentTimeMillis());
    }

    protected boolean accumulateExceptions() {
        return false;
    }
}

