/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.admin.cache;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheNodeResponse;

public class StatsFilterJoinCacheResponse
extends BaseNodesResponse<StatsFilterJoinCacheNodeResponse>
implements ToXContent {
    StatsFilterJoinCacheResponse() {
    }

    StatsFilterJoinCacheResponse(ClusterName clusterName, StatsFilterJoinCacheNodeResponse[] nodes) {
        super(clusterName, (BaseNodeResponse[])nodes);
    }

    public StatsFilterJoinCacheNodeResponse[] getNodeResponses() {
        return (StatsFilterJoinCacheNodeResponse[])this.nodes;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new StatsFilterJoinCacheNodeResponse[in.readVInt()];
        for (int i = 0; i < ((StatsFilterJoinCacheNodeResponse[])this.nodes).length; ++i) {
            ((StatsFilterJoinCacheNodeResponse[])this.nodes)[i] = StatsFilterJoinCacheNodeResponse.readNodeStats(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((StatsFilterJoinCacheNodeResponse[])this.nodes).length);
        for (StatsFilterJoinCacheNodeResponse node : (StatsFilterJoinCacheNodeResponse[])this.nodes) {
            node.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_name", this.getClusterName().value());
        builder.startObject("nodes");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StatsFilterJoinCacheNodeResponse node = (StatsFilterJoinCacheNodeResponse)((Object)iterator.next());
            builder.startObject(node.getNode().getName(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("timestamp", node.getTimestamp());
            builder.startObject("stats");
            builder.field("size", node.getCacheStats().getSize());
            builder.field("requestCount", node.getCacheStats().getCacheStats().requestCount());
            builder.field("hitCount", node.getCacheStats().getCacheStats().hitCount());
            builder.field("hitRate", node.getCacheStats().getCacheStats().hitRate());
            builder.field("missCount", node.getCacheStats().getCacheStats().missCount());
            builder.field("missRate", node.getCacheStats().getCacheStats().missRate());
            builder.field("loadCount", node.getCacheStats().getCacheStats().loadCount());
            builder.field("loadSuccessCount", node.getCacheStats().getCacheStats().loadSuccessCount());
            builder.field("loadExceptionCount", node.getCacheStats().getCacheStats().loadExceptionCount());
            builder.field("loadExceptionRate", node.getCacheStats().getCacheStats().loadExceptionRate());
            builder.field("totalLoadTime", node.getCacheStats().getCacheStats().totalLoadTime());
            builder.field("evictionCount", node.getCacheStats().getCacheStats().evictionCount());
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

