/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import solutions.siren.join.SirenJoinNodeModule;
import solutions.siren.join.SirenJoinShardModule;
import solutions.siren.join.action.admin.cache.ClearFilterJoinCacheAction;
import solutions.siren.join.action.admin.cache.StatsFilterJoinCacheAction;
import solutions.siren.join.action.admin.cache.TransportClearFilterJoinCacheAction;
import solutions.siren.join.action.admin.cache.TransportStatsFilterJoinCacheAction;
import solutions.siren.join.action.admin.version.GetIndicesVersionAction;
import solutions.siren.join.action.admin.version.IndexVersionShardService;
import solutions.siren.join.action.admin.version.TransportGetIndicesVersionAction;
import solutions.siren.join.action.coordinate.CoordinateMultiSearchAction;
import solutions.siren.join.action.coordinate.CoordinateSearchAction;
import solutions.siren.join.action.coordinate.TransportCoordinateMultiSearchAction;
import solutions.siren.join.action.coordinate.TransportCoordinateSearchAction;
import solutions.siren.join.action.terms.TermsByQueryAction;
import solutions.siren.join.action.terms.TransportTermsByQueryAction;
import solutions.siren.join.index.query.FieldDataTermsQueryParser;
import solutions.siren.join.index.query.TermsEnumTermsQueryParser;
import solutions.siren.join.rest.RestClearFilterJoinCacheAction;
import solutions.siren.join.rest.RestCoordinateMultiSearchAction;
import solutions.siren.join.rest.RestCoordinateSearchAction;
import solutions.siren.join.rest.RestStatsFilterJoinCacheAction;

public class SirenJoinPlugin
extends Plugin {
    private final boolean isEnabled;

    @Inject
    public SirenJoinPlugin(Settings settings) {
        this.isEnabled = DiscoveryNode.clientNode((Settings)settings) ? "node".equals(settings.get("client.type")) : true;
    }

    public void onModule(ActionModule module) {
        module.registerAction((GenericAction)TermsByQueryAction.INSTANCE, TransportTermsByQueryAction.class, new Class[0]);
        module.registerAction((GenericAction)CoordinateSearchAction.INSTANCE, TransportCoordinateSearchAction.class, new Class[0]);
        module.registerAction((GenericAction)CoordinateMultiSearchAction.INSTANCE, TransportCoordinateMultiSearchAction.class, new Class[0]);
        module.registerAction((GenericAction)ClearFilterJoinCacheAction.INSTANCE, TransportClearFilterJoinCacheAction.class, new Class[0]);
        module.registerAction((GenericAction)StatsFilterJoinCacheAction.INSTANCE, TransportStatsFilterJoinCacheAction.class, new Class[0]);
        module.registerAction((GenericAction)GetIndicesVersionAction.INSTANCE, TransportGetIndicesVersionAction.class, new Class[0]);
    }

    public void onModule(IndicesModule module) {
        module.registerQueryParser(FieldDataTermsQueryParser.class);
        module.registerQueryParser(TermsEnumTermsQueryParser.class);
    }

    public void onModule(RestModule module) {
        module.addRestAction(RestCoordinateSearchAction.class);
        module.addRestAction(RestCoordinateMultiSearchAction.class);
        module.addRestAction(RestClearFilterJoinCacheAction.class);
        module.addRestAction(RestStatsFilterJoinCacheAction.class);
    }

    public Collection<Module> nodeModules() {
        if (this.isEnabled) {
            return Collections.singletonList(new SirenJoinNodeModule());
        }
        return Collections.emptyList();
    }

    public Collection<Module> shardModules(Settings indexSettings) {
        return Collections.singletonList(new SirenJoinShardModule());
    }

    public Collection<Class<? extends Closeable>> shardServices() {
        ArrayList<Class<? extends Closeable>> services = new ArrayList<Class<? extends Closeable>>();
        services.add(IndexVersionShardService.class);
        return services;
    }

    public String name() {
        return "SirenJoinPlugin";
    }

    public String description() {
        return "SIREn plugin that adds join capabilities to Elasticsearch";
    }

    public Settings additionalSettings() {
        return Settings.builder().put("index.queries.cache.everything", true).build();
    }
}

