/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.State;
import org.apache.util.DOMUtils;
import org.apache.util.DOMWriter;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.CurrentUserPrivilegeSetProperty;
import org.apache.webdav.lib.properties.GetLastModifiedProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.OwnerProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;
import org.apache.webdav.lib.properties.SupportedLockProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLResponseMethodBase
extends HttpMethodBase {
    private Document responseDocument = null;
    protected DocumentBuilder builder = null;
    private Hashtable responseHashtable = null;

    public XMLResponseMethodBase() {
    }

    public XMLResponseMethodBase(String path) {
        super(path);
    }

    protected static Property convertElementToProperty(Response response, Element element) {
        BaseProperty property = null;
        String namespace = DOMUtils.getElementNamespaceURI(element);
        if (namespace != null && namespace.equals("DAV:")) {
            String localName = DOMUtils.getElementLocalName(element);
            if ("resourcetype".equals(localName)) {
                property = new ResourceTypeProperty(response, element);
            } else if ("getlastmodified".equals(localName)) {
                property = new GetLastModifiedProperty(response, element);
            } else if ("current-user-privilege-set".equals(localName)) {
                property = new CurrentUserPrivilegeSetProperty(response, element);
            } else if ("lockdiscovery".equals(localName)) {
                property = new LockDiscoveryProperty(response, element);
            } else if ("supportedlock".equals(localName)) {
                property = new SupportedLockProperty(response, element);
            } else if ("acl".equals(localName)) {
                property = new AclProperty(response, element);
            } else if ("principal-collection-set".equals(localName)) {
                property = new PrincipalCollectionSetProperty(response, element);
            } else if ("owner".equals(localName)) {
                property = new OwnerProperty(response, element);
            }
        }
        if (property == null) {
            property = new BaseProperty(response, element);
        }
        return property;
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    protected Hashtable getResponseHashtable() {
        this.checkUsed();
        if (this.responseHashtable == null) {
            this.initResponseHashtable();
        }
        return this.responseHashtable;
    }

    public Enumeration getResponses() {
        return this.getResponseHashtable().elements();
    }

    protected State getState() {
        return this.state;
    }

    private synchronized void initResponseHashtable() {
        if (this.responseHashtable == null) {
            this.responseHashtable = new Hashtable();
            int status = this.getStatusCode();
            if (status == 207) {
                Element multistatus = this.getResponseDocument().getDocumentElement();
                NodeList list = multistatus.getChildNodes();
                if (list != null) {
                    int i = 0;
                    while (i < list.getLength()) {
                        try {
                            Element child = (Element)list.item(i);
                            String name = DOMUtils.getElementLocalName(child);
                            String namespace = DOMUtils.getElementNamespaceURI(child);
                            if ("response".equals(name) && "DAV:".equals(namespace)) {
                                ResponseWithinMultistatus response = new ResponseWithinMultistatus(child);
                                this.responseHashtable.put(((Response)response).getHref(), response);
                                if (this.debug > 10) {
                                    System.out.println(response);
                                }
                            }
                        }
                        catch (ClassCastException classCastException) {}
                        ++i;
                    }
                }
            } else if (this.responseDocument != null) {
                SingleResponse response = new SingleResponse(this.responseDocument, this.getPath(), status);
                this.responseHashtable.put(((Response)response).getHref(), response);
                if (this.debug > 10) {
                    System.out.println(response);
                }
            }
        }
    }

    public void parseResponse(InputStream input) throws IOException, HttpException {
        if (this.getStatusCode() == 207) {
            this.parseXMLResponse(input);
        }
    }

    protected void parseXMLResponse(InputStream input) throws IOException, HttpException {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new HttpException("XML Parser Configuration error: " + e.getMessage());
            }
        }
        try {
            this.responseDocument = this.builder.parse(new InputSource(input));
        }
        catch (Exception e) {
            throw new IOException("XML parsing error; response stream is not valid XML: " + e.getMessage());
        }
        if (this.debug > 10) {
            this.initResponseHashtable();
        }
    }

    public void recycle() {
        super.recycle();
        this.responseHashtable = null;
    }

    public abstract class Response
    implements ResponseEntity {
        protected Node node = null;
        public static final String TAG_NAME = "response";

        Response(Node node) {
            this.node = node;
        }

        public abstract String getHref();

        public Enumeration getProperties() {
            NodeList list = DOMUtils.getElementsByTagNameNS(this.node, "prop", "DAV:");
            Vector<Property> vector = new Vector<Property>();
            int i = 0;
            while (list != null && i < list.getLength()) {
                Element element = (Element)list.item(i);
                NodeList children = element.getChildNodes();
                int j = 0;
                while (children != null && j < children.getLength()) {
                    try {
                        Element child = (Element)children.item(j);
                        vector.addElement(XMLResponseMethodBase.convertElementToProperty(this, child));
                    }
                    catch (ClassCastException classCastException) {}
                    ++j;
                }
                ++i;
            }
            return vector.elements();
        }

        public abstract int getStatusCode();

        public String toString() {
            StringWriter tmp = new StringWriter();
            DOMWriter domWriter = new DOMWriter(tmp, true);
            domWriter.print(this.node);
            return tmp.getBuffer().toString();
        }
    }

    class ResponseWithinMultistatus
    extends Response {
        public ResponseWithinMultistatus(Element element) {
            super(element);
        }

        protected Element getFirstElement(String namespace, String name) {
            return DOMUtils.getFirstElement(this.node, namespace, name);
        }

        public String getHref() {
            Element href = this.getFirstElement("DAV:", "href");
            if (href != null) {
                return XMLResponseMethodBase.this.getState().URLDecode(DOMUtils.getTextValue(href));
            }
            return "";
        }

        public int getStatusCode() {
            Element status;
            Element propstat = this.getFirstElement("DAV:", "propstat");
            if (propstat != null && (status = DOMUtils.getFirstElement(propstat, "DAV:", "status")) != null) {
                return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
            }
            status = this.getFirstElement("DAV:", "status");
            if (status != null) {
                return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
            }
            return -1;
        }
    }

    class SingleResponse
    extends Response {
        private int statusCode = -1;
        private String href = null;

        SingleResponse(Document document, String href, int statusCode) {
            super(document);
            this.statusCode = statusCode;
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

