/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.State;
import org.apache.webdav.lib.WebdavState;

public class UnlockMethod
extends HttpMethodBase {
    private String lockToken = null;

    public UnlockMethod() {
        this.name = "UNLOCK";
    }

    public UnlockMethod(String path) {
        super(path);
        this.name = "UNLOCK";
    }

    public UnlockMethod(String path, String lockToken) {
        this(path);
        this.setLockToken(lockToken);
    }

    public void generateHeaders(String host, State state) {
        super.generateHeaders(host, state);
        super.setHeader("Lock-Token", "<" + this.lockToken + ">");
    }

    public void parseResponse(InputStream is) throws IOException {
        if (this.getStatusCode() == 204) {
            ((WebdavState)this.state).removeLock(this.getPath(), this.lockToken);
        }
    }

    public void setHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Lock-Token")) {
            this.setLockToken(headerValue);
        } else {
            super.setHeader(headerName, headerValue);
        }
    }

    public void setLockToken(String lockToken) {
        this.checkNotUsed();
        this.lockToken = lockToken;
    }
}

