/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.httpclient.State;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class PropPatchMethod
extends XMLResponseMethodBase {
    protected Hashtable toSet = new Hashtable();
    protected Hashtable toRemove = new Hashtable();

    public PropPatchMethod() {
        this.name = "PROPPATCH";
    }

    public PropPatchMethod(String path) {
        super(path);
        this.name = "PROPPATCH";
    }

    public void addPropertyToRemove(String name) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            this.toRemove.put(name, propertyToRemove);
        }
    }

    public void addPropertyToRemove(String name, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            propertyToRemove.namespace = namespace;
            propertyToRemove.namespaceInfo = namespaceInfo;
            this.toRemove.put(name, propertyToRemove);
        }
    }

    public void addPropertyToSet(String name, String value) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            this.toSet.put(name, propertyToSet);
        }
    }

    public void addPropertyToSet(String name, String value, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            propertyToSet.namespace = namespace;
            propertyToSet.namespaceInfo = namespaceInfo;
            this.toSet.put(String.valueOf(namespace) + name, propertyToSet);
        }
    }

    public void generateHeaders(String host, State state) {
        super.generateHeaders(host, state);
        super.setHeader("Content-Type", "text/xml; charset=utf-8");
    }

    public String generateQuery() {
        Property current;
        if (this.query != null) {
            return this.query;
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "propertyupdate", 0);
        if (this.toSet.size() > 0) {
            printer.writeElement("D", null, "set", 0);
            Enumeration toSetList = this.toSet.elements();
            printer.writeElement("D", null, "prop", 0);
            while (toSetList.hasMoreElements()) {
                current = (Property)toSetList.nextElement();
                if ("DAV:".equals(current.namespaceInfo)) {
                    printer.writeProperty("D", null, current.name, current.value);
                    continue;
                }
                printer.writeProperty(current.namespace, current.namespaceInfo, current.name, current.value);
            }
            printer.writeElement("D", null, "prop", 1);
            printer.writeElement("D", null, "set", 1);
        }
        if (this.toRemove.size() > 0) {
            printer.writeElement("D", null, "remove", 0);
            Enumeration toRemoveList = this.toRemove.elements();
            printer.writeElement("D", null, "prop", 0);
            while (toRemoveList.hasMoreElements()) {
                current = (Property)toRemoveList.nextElement();
                printer.writeElement(current.namespace, current.namespaceInfo, current.name, 2);
            }
            printer.writeElement("D", null, "prop", 1);
            printer.writeElement("D", null, "remove", 1);
        }
        printer.writeElement("D", "propertyupdate", 1);
        this.query = printer.toString();
        return this.query;
    }

    private class Property {
        public String name = "";
        public String namespace;
        public String namespaceInfo;
        public String value;

        Property() {
        }
    }
}

