/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;

public class OptionsMethod
extends HttpMethodBase {
    public static final String DAV_LEVEL1 = "1";
    public static final String DAV_LEVEL2 = "2";
    public static final String ADVANCED_COLLECTIONS = "3";
    public static final String DELTAV = "4";
    public static final String ACL = "5";
    public static final String DASL = "6";
    private Vector davCapabilities = new Vector();
    private Vector methodsAllowed = new Vector();

    public OptionsMethod() {
        this.name = "OPTIONS";
    }

    public OptionsMethod(String path) {
        super(path);
        this.name = "OPTIONS";
    }

    public String generateQuery() {
        return null;
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    public Enumeration getDavCapabilities() {
        this.checkUsed();
        return this.davCapabilities.elements();
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.methodsAllowed.contains(method);
    }

    public boolean isSupported(String capability) {
        this.checkUsed();
        return this.davCapabilities.contains(capability);
    }

    public void parseResponse(InputStream is) throws IOException {
    }

    public void processResponseHeaders(Hashtable headers) {
        Header allowHeader;
        Header davHeader = (Header)headers.get("dav");
        if (davHeader != null) {
            String davHeaderValue = davHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(davHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String davCapability = tokenizer.nextToken().trim();
                this.davCapabilities.addElement(davCapability);
            }
        }
        if ((allowHeader = (Header)headers.get("allow")) != null) {
            String allowHeaderValue = allowHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(allowHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String methodAllowed = tokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(methodAllowed);
            }
        }
    }
}

