/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import org.apache.commons.httpclient.State;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MoveMethod
extends XMLResponseMethodBase {
    private String destination;
    private boolean overwrite = true;

    public MoveMethod() {
        this.name = "MOVE";
    }

    public MoveMethod(String source) {
        super(source);
        this.name = "MOVE";
    }

    public MoveMethod(String source, String destination) {
        this(source);
        this.setDestination(destination);
    }

    public MoveMethod(String source, String destination, boolean overwrite) {
        this(source, destination);
        this.setOverwrite(overwrite);
    }

    public void generateHeaders(String host, State state) {
        super.generateHeaders(host, state);
        String absoluteDestination = "http://" + host + state.URLEncode(this.destination);
        super.setHeader("Destination", absoluteDestination);
        if (!this.isOverwrite()) {
            super.setHeader("Overwrite", "F");
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestination(String destination) {
        this.checkNotUsed();
        this.destination = destination;
    }

    public void setHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Overwrite")) {
            this.setOverwrite((headerValue.equalsIgnoreCase("F") || headerValue.equalsIgnoreCase("False")) ^ true);
        } else if (headerName.equalsIgnoreCase("Destination")) {
            this.setDestination(headerValue);
        } else {
            super.setHeader(headerName, headerValue);
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.checkNotUsed();
        this.overwrite = overwrite;
    }
}

