/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.State;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;

public class AclMethod
extends HttpMethodBase {
    protected Vector aces = new Vector();

    public AclMethod() {
        this.name = "ACL";
    }

    public AclMethod(String path) {
        super(path);
        this.name = "ACL";
    }

    public void addAce(Ace ace) {
        this.checkNotUsed();
        this.aces.addElement(ace);
    }

    public void generateHeaders(String host, State state) {
        super.generateHeaders(host, state);
        super.setHeader("Content-Type", "text/xml; charset=utf-8");
    }

    public String generateQuery() {
        if (this.query != null) {
            return this.query;
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "acl", 0);
        Enumeration aceList = this.aces.elements();
        while (aceList.hasMoreElements()) {
            Ace ace = (Ace)aceList.nextElement();
            if (ace.isInherited() || ace.isProtected()) continue;
            printer.writeElement("D", null, "ace", 0);
            printer.writeElement("D", null, "principal", 0);
            boolean found = false;
            String principal = ace.getPrincipal();
            String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
            int i = 0;
            while (i < types.length && !found) {
                if (types[i].equals(principal)) {
                    found = true;
                    printer.writeElement("D", null, principal, 2);
                }
                ++i;
            }
            if (!found) {
                printer.writeElement("D", null, "href", 0);
                printer.writeText(ace.getPrincipal());
                printer.writeElement("D", null, "href", 1);
            }
            printer.writeElement("D", null, "principal", 1);
            String positive = ace.isNegative() ? "deny" : "grant";
            printer.writeElement("D", null, positive, 0);
            Enumeration privilegeList = ace.enumeratePrivileges();
            while (privilegeList.hasMoreElements()) {
                Privilege privilege = (Privilege)privilegeList.nextElement();
                printer.writeElement("D", null, "privilege", 0);
                printer.writeElement(null, privilege.getNamespace(), privilege.getName(), 2);
                printer.writeElement("D", null, "privilege", 1);
            }
            printer.writeElement("D", null, positive, 1);
            if (ace.isInherited()) {
                printer.writeElement("D", null, "inherited", 2);
            }
            printer.writeElement("D", null, "ace", 1);
        }
        printer.writeElement("D", "acl", 1);
        this.query = printer.toString();
        return this.query;
    }

    public void parseResponse(InputStream is) throws IOException {
    }

    public void processResponseHeaders(Hashtable headers) {
    }

    public void recycle() {
        super.recycle();
        this.aces.clear();
    }
}

