/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.httpclient.ConnectionInterceptor;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.State;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavState;

public abstract class WebdavSession
implements ConnectionInterceptor {
    protected HttpClient client;
    protected int debug = 0;

    public void authenticate() {
        if (this.debug == 9) {
            System.err.println("CLIENT: authenticating.");
        }
    }

    public void closeSession() throws IOException {
        if (this.client != null) {
            this.client.endSession();
            this.client = null;
        }
    }

    public synchronized void closeSession(HttpClient client) throws IOException {
        this.closeSession();
    }

    public void connect() {
        if (this.debug == 9) {
            System.err.println("CLIENT: connected.");
        }
    }

    public void disconnect() {
        if (this.debug == 9) {
            System.err.println("CLIENT: disconnected.");
        }
    }

    public boolean error(int status, Exception e) {
        if (this.debug == 9) {
            System.err.println("CLIENT: Status: " + status + ", Exception: " + e.getMessage());
        }
        return false;
    }

    public HttpClient getSessionInstance(HttpURL httpURL) throws IOException {
        return this.getSessionInstance(httpURL, false);
    }

    public HttpClient getSessionInstance(HttpURL httpURL, boolean reset) throws IOException {
        String authority = httpURL.getAuthority();
        if (reset) {
            this.client = null;
        }
        if (this.client == null) {
            this.client = new HttpClient();
            this.client.setDebug(this.debug);
            this.client.setState((State)new WebdavState());
            this.client.startSession(httpURL.getHost(), httpURL.getPort());
            String userName = httpURL.getUserName();
            if (userName != null && userName.length() > 0) {
                String password = httpURL.getPassword();
                this.client.setCredentials(new Credentials(userName, password));
            }
            this.client.setConnectionInterceptor((ConnectionInterceptor)this);
        }
        return this.client;
    }

    public boolean info(int status, Hashtable headers) {
        if (this.debug == 9) {
            System.err.println("CLIENT: Status: " + status + "\nHeaders: ");
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String header = (String)keys.nextElement();
                String value = (String)headers.get(header);
                System.err.println("\t" + header + ": " + value);
            }
        }
        return false;
    }

    public void receivedExpectation() {
        if (this.debug == 9) {
            System.err.println("CLIENT: received expectation.");
        }
    }

    public void receivedResponse() {
        if (this.debug == 9) {
            System.err.println("CLIENT: received response.");
        }
    }

    public void requiredAuthentication() {
        if (this.debug == 9) {
            System.err.println("CLIENT: required authentication.");
        }
    }

    public boolean retry(int status) {
        if (this.debug == 9) {
            System.err.println("CLIENT: retrying.");
        }
        return false;
    }

    public void sentRequest() {
        if (this.debug == 9) {
            System.err.println("CLIENT: sent request.");
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
        if (this.client != null) {
            this.client.setDebug(debug);
        }
    }
}

