/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.State;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.util.GenericURI;
import org.apache.util.HttpURL;
import org.apache.util.WebdavStatus;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResources;
import org.apache.webdav.lib.WebdavSession;
import org.apache.webdav.lib.WebdavState;
import org.apache.webdav.lib.methods.AclMethod;
import org.apache.webdav.lib.methods.CopyMethod;
import org.apache.webdav.lib.methods.DeleteMethod;
import org.apache.webdav.lib.methods.LockMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.UnlockMethod;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class WebdavResource
extends WebdavSession {
    public static final String DISPLAYNAME = "displayname";
    public static final String GETCONTENTLENGTH = "getcontentlength";
    public static final String GETLASTMODIFIED = "getlastmodified";
    public static final String CREATIONDATE = "creationdate";
    public static final String RESOURCETYPE = "resourcetype";
    public static final String GETCONTENTTYPE = "getcontenttype";
    public static final String GETETAG = "getetag";
    public static final String ISHIDDEN = "ishidden";
    public static final String ISCOLLECTION = "iscollection";
    public static final String SUPPORTEDLOCK = "supportedlock";
    public static final String LOCKDISCOVERY = "lockdiscovery";
    public static final int NOACTION = 1;
    public static final int NAME = 2;
    public static final int BASIC = 3;
    public static final int DEFAULT = 4;
    public static final int ALL = 5;
    public static final String defaultOwner = "Slide";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private HttpURL httpURL;
    private WebdavResources childResources = new WebdavResources();
    private static int defaultAction;
    private static int defaultDepth;
    private static String tempDirForGet;
    private static boolean useDiskForGet;
    private boolean thisResource;
    private Enumeration allowedMethods;
    private Enumeration davCapabilities;
    private boolean exists;
    private boolean overwrite;
    private int latestStatusCode;
    private String latestStatusMessage = "";
    private String displayName = "";
    private long getContentLength;
    private String getContentType = "";
    private ResourceTypeProperty resourceType;
    private long getLastModified;
    private long creationDate;
    private String getEtag = "";
    private boolean isHidden;
    private boolean isCollection;
    private String supportedLock = "";
    private LockDiscoveryProperty lockDiscovery;

    static {
        int i = 0;
        while (i < formats.length) {
            formats[i].setTimeZone(gmtZone);
            ++i;
        }
        defaultAction = 3;
        defaultDepth = 0;
        useDiskForGet = true;
    }

    public WebdavResource(String escapedHttpURL) throws HttpException, IOException {
        this.setHttpURL(escapedHttpURL);
    }

    private WebdavResource(HttpClient client) {
        this.client = client;
    }

    public WebdavResource(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, depth);
    }

    public WebdavResource(HttpURL httpURL, int action, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, action, depth);
    }

    public WebdavResource(HttpURL httpURL, String additionalPath) throws HttpException, IOException {
        this.setHttpURL(httpURL, additionalPath);
    }

    public boolean aclMethod(String path, Ace[] aces) throws HttpException, IOException {
        this.setClient();
        AclMethod method = new AclMethod(path);
        this.generateIfHeader((HttpMethod)method);
        int i = 0;
        while (i < aces.length) {
            Ace ace = aces[i];
            method.addAce(ace);
            ++i;
        }
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public AclProperty aclfindMethod(String path) throws HttpException, IOException {
        this.setClient();
        AclProperty acl = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement("acl");
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), 0, properties.elements());
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof AclProperty)) continue;
                acl = (AclProperty)property;
            }
        }
        return acl;
    }

    public void close() throws IOException {
        this.closeSession();
    }

    public int compareTo(Object another) {
        if (another != null && another instanceof WebdavResource) {
            return this.compareToWebdavResource((WebdavResource)another);
        }
        String thisUrl = this.toString();
        String anotherUrl = another.toString();
        return thisUrl.compareTo(anotherUrl);
    }

    public int compareToWebdavResource(WebdavResource another) {
        try {
            int anotherPort;
            HttpURL anotherUrl = another.getHttpURL();
            String thisHost = this.httpURL.getHost();
            String anotherHost = anotherUrl.getHost();
            if (!thisHost.equalsIgnoreCase(anotherHost)) {
                return thisHost.compareTo(anotherHost);
            }
            int thisPort = this.httpURL.getPort();
            if (thisPort != (anotherPort = anotherUrl.getPort())) {
                return thisPort < anotherPort ? -1 : 1;
            }
            boolean thisCollection = this.isCollection();
            boolean anotherCollection = another.isCollection();
            if (thisCollection && !anotherCollection) {
                return -1;
            }
            if (anotherCollection && !thisCollection) {
                return 1;
            }
            String thisPath = this.httpURL.getPathQuery();
            String anotherPath = anotherUrl.getPathQuery();
            return thisPath.compareTo(anotherPath);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean copyMethod(String destination) throws HttpException, IOException {
        boolean result = this.copyMethod(this.httpURL.getPath(), GenericURI.getPath(destination));
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean copyMethod(String source, String destination) throws HttpException, IOException {
        this.setClient();
        CopyMethod method = new CopyMethod(source, destination);
        this.generateIfHeader((HttpMethod)method);
        method.setOverwrite(this.overwrite);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean deleteMethod() throws HttpException, IOException {
        boolean result = this.deleteMethod(this.httpURL.getPath());
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean deleteMethod(String path) throws HttpException, IOException {
        this.setClient();
        DeleteMethod method = new DeleteMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WebdavResource) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int executeHttpRequestMethod(HttpClient client, HttpMethod method) throws IOException, HttpException {
        client.executeMethod(method);
        return method.getStatusCode();
    }

    public boolean exists() {
        return this.getExistence();
    }

    private void generateIfHeader(HttpMethod method) {
        if (this.client == null) {
            return;
        }
        if (method == null) {
            return;
        }
        WebdavState state = (WebdavState)this.client.getState();
        String[] lockTokens = state.getAllLocks(method.getPath());
        if (lockTokens.length == 0) {
            return;
        }
        StringBuffer ifHeaderValue = new StringBuffer();
        int i = 0;
        while (i < lockTokens.length) {
            ifHeaderValue.append("(<").append(lockTokens[i]).append(">) ");
            ++i;
        }
        method.setHeader("If", ifHeaderValue.toString());
    }

    public Enumeration getActiveLockOwners() {
        if (this.lockDiscovery == null) {
            return null;
        }
        Lock[] activeLocks = this.lockDiscovery.getActiveLocks();
        if (activeLocks == null) {
            return null;
        }
        Vector<String> buff = new Vector<String>();
        int count = activeLocks.length;
        int i = 0;
        while (i < count) {
            buff.addElement(activeLocks[i].getOwner());
            ++i;
        }
        return buff.elements();
    }

    public Enumeration getAllowedMethods() {
        return this.allowedMethods;
    }

    public WebdavResources getChildResources() throws HttpException, IOException {
        this.setProperties(1);
        return this.childResources;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Enumeration getDavCapabilities() {
        return this.davCapabilities;
    }

    public static int getDefaultAction() {
        return defaultAction;
    }

    public static int getDefaultDepth() {
        return defaultDepth;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getExistence() {
        return this.exists;
    }

    public long getGetContentLength() {
        return this.getContentLength;
    }

    public String getGetContentType() {
        return this.getContentType;
    }

    public String getGetEtag() {
        return this.getEtag;
    }

    public long getGetLastModified() {
        return this.getLastModified;
    }

    public static String getGetTempDir() {
        return tempDirForGet;
    }

    public static boolean getGetUseDisk() {
        return useDiskForGet;
    }

    public String getHost() throws MalformedURLException {
        return this.httpURL.getHost();
    }

    public HttpURL getHttpURL() {
        return this.httpURL;
    }

    public HttpURL getHttpURLExceptForUserInfo() throws MalformedURLException {
        return this.httpURL.getHttpURLExceptForUserInfo();
    }

    public boolean getIsCollection() {
        return this.isCollection;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public LockDiscoveryProperty getLockDiscovery() {
        return this.lockDiscovery;
    }

    public boolean getMethod(File file) throws HttpException, IOException {
        return this.getMethod(this.httpURL.getPathQuery(), file);
    }

    public boolean getMethod(String path, File file) throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(GenericURI.getPathQuery(path), file);
        method.setUseDisk(true);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public InputStream getMethodData() throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(this.httpURL.getPath());
        method.setUseDisk(useDiskForGet);
        if (tempDirForGet != null) {
            method.setTempDir(tempDirForGet);
        }
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        return method.getData();
    }

    public String getMethodDataAsString() throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(this.httpURL.getPath());
        method.setUseDisk(useDiskForGet);
        if (tempDirForGet != null) {
            method.setTempDir(tempDirForGet);
        }
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        return method.getDataAsString();
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String getPath() {
        return this.httpURL.getPath();
    }

    public ResourceTypeProperty getResourceType() {
        return this.resourceType;
    }

    public int getStatusCode() {
        return this.latestStatusCode;
    }

    public String getStatusMessage() {
        return this.latestStatusMessage;
    }

    public String getSupportedLock() {
        return this.supportedLock;
    }

    public boolean headMethod() throws HttpException, IOException {
        return this.headMethod(this.httpURL.getPath());
    }

    public boolean headMethod(String path) throws HttpException, IOException {
        this.setClient();
        HeadMethod method = new HeadMethod(GenericURI.getPath(path));
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean isCollection() {
        if (this.getResourceType() == null) {
            return false;
        }
        return this.getResourceType().isCollection();
    }

    public boolean isLocked() {
        if (this.lockDiscovery == null) {
            return false;
        }
        Lock[] activeLocks = this.lockDiscovery.getActiveLocks();
        if (activeLocks == null) {
            return false;
        }
        int i = 0;
        while (i < activeLocks.length) {
            if (activeLocks[i].getLockType() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private synchronized boolean isTheClient() throws MalformedURLException {
        HttpURL clientHttpURL = new HttpURL(this.client.getUserName(), this.client.getPassword(), this.client.getHost(), this.client.getPort());
        return clientHttpURL.getAuthority().equals(this.httpURL.getAuthority());
    }

    public String[] list() {
        try {
            this.setNameProperties(1);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HttpException httpException) {
            return null;
        }
        Enumeration hrefs = this.childResources.getResourceNames();
        Vector<String> hrefList = new Vector<String>();
        while (hrefs.hasMoreElements()) {
            hrefList.addElement((String)hrefs.nextElement());
        }
        int num = hrefList.size();
        String[] pathnames = new String[num];
        int i = 0;
        while (i < num) {
            pathnames[i] = (String)hrefList.elementAt(i);
            ++i;
        }
        return pathnames;
    }

    public Vector listBasic() throws HttpException, IOException {
        this.setBasicProperties(1);
        Enumeration hrefs = this.childResources.getResourceNames();
        Vector<String[]> hrefList = new Vector<String[]>();
        while (hrefs.hasMoreElements()) {
            try {
                String resourceName = (String)hrefs.nextElement();
                WebdavResource currentResource = this.childResources.getResource(resourceName);
                String[] longFormat = new String[4];
                longFormat[0] = currentResource.getDisplayName();
                long length = currentResource.getGetContentLength();
                longFormat[1] = new Long(length).toString();
                ResourceTypeProperty resourceTypeProperty = currentResource.getResourceType();
                String getContentType = currentResource.getGetContentType();
                longFormat[2] = resourceTypeProperty.isCollection() ? "COLLECTION" : getContentType;
                Date date = new Date(currentResource.getGetLastModified());
                longFormat[3] = date == null ? "-- -- ----" : DateFormat.getDateTimeInstance().format(date);
                hrefList.addElement(longFormat);
            }
            catch (Exception e) {
                if (this.debug <= 0) continue;
                e.printStackTrace();
            }
        }
        return hrefList;
    }

    public WebdavResource[] listWebdavResources() throws HttpException, IOException {
        return this.getChildResources().listResources();
    }

    public LockDiscoveryProperty lockDiscoveryPropertyFindMethod(String path) throws HttpException, IOException {
        this.setClient();
        LockDiscoveryProperty set = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement(LOCKDISCOVERY);
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), 0, properties.elements());
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof LockDiscoveryProperty)) continue;
                set = (LockDiscoveryProperty)property;
            }
        }
        return set;
    }

    public boolean lockMethod() throws HttpException, IOException {
        String owner = null;
        owner = this.httpURL.getUserName() != null ? String.valueOf(this.httpURL.getUserName()) + "@" + this.httpURL.getHost() : "Slide@" + this.httpURL.getHost();
        boolean result = this.lockMethod(this.httpURL.getPath(), owner, (short)120);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean lockMethod(String path) throws HttpException, IOException {
        String owner = null;
        owner = this.httpURL.getUserName() != null ? String.valueOf(this.httpURL.getUserName()) + "@" + this.httpURL.getHost() : "Slide@" + this.httpURL.getHost();
        return this.lockMethod(path, owner, (short)120);
    }

    public boolean lockMethod(String path, String owner, short timeout) throws HttpException, IOException {
        this.setClient();
        short lockType = 0;
        LockMethod method = new LockMethod(GenericURI.getPath(path), owner, lockType, timeout);
        this.generateIfHeader((HttpMethod)method);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        String lock = method.getLockToken();
        WebdavState state = (WebdavState)this.client.getState();
        if (state != null) {
            state.addLock(path, lock);
        }
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode, lock);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean lockMethod(String owner, short timeout) throws HttpException, IOException {
        boolean result = this.lockMethod(this.httpURL.getPath(), owner, timeout);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean mkcolMethod() throws HttpException, IOException {
        boolean result = this.mkcolMethod(this.httpURL.getPath());
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean mkcolMethod(String path) throws HttpException, IOException {
        this.setClient();
        MkcolMethod method = new MkcolMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode == 405 || statusCode >= 200 && statusCode < 300;
    }

    public boolean moveMethod(String destination) throws HttpException, IOException {
        boolean result = this.moveMethod(this.httpURL.getPath(), GenericURI.getPath(destination));
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean moveMethod(String source, String destination) throws HttpException, IOException {
        this.setClient();
        MoveMethod method = new MoveMethod(source, destination);
        this.generateIfHeader((HttpMethod)method);
        method.setOverwrite(this.overwrite);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean optionsMethod() throws HttpException, IOException {
        return this.optionsMethod(this.httpURL.getPath());
    }

    public boolean optionsMethod(String path) throws HttpException, IOException {
        this.setClient();
        OptionsMethod method = path.trim().equals("*") ? new OptionsMethod("*") : new OptionsMethod(GenericURI.getPath(path));
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            this.allowedMethods = method.getAllowedMethods();
            this.davCapabilities = method.getDavCapabilities();
            return true;
        }
        return false;
    }

    public boolean optionsMethod(String path, String aMethod) throws HttpException, IOException {
        if (aMethod != null && this.optionsMethod(this.httpURL.getPath())) {
            while (this.allowedMethods.hasMoreElements()) {
                if (!aMethod.equalsIgnoreCase((String)this.allowedMethods.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration optionsMethod(HttpURL httpURL) throws HttpException, IOException {
        HttpClient client = this.getSessionInstance(httpURL, true);
        OptionsMethod method = new OptionsMethod(httpURL.getPath());
        client.executeMethod((HttpMethod)method);
        Vector options = new Vector();
        int statusCode = method.getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            Enumeration allowedMethods = method.getAllowedMethods();
            while (allowedMethods.hasMoreElements()) {
                options.addElement(allowedMethods.nextElement());
            }
            Enumeration davCapabilities = method.getDavCapabilities();
            while (davCapabilities.hasMoreElements()) {
                options.addElement(davCapabilities.nextElement());
            }
        }
        return options.elements();
    }

    private Date parseDate(String dateValue) {
        Date date = null;
        int i = 0;
        while (date == null && i < formats.length) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    date = formats[i].parse(dateValue);
                }
            }
            catch (ParseException parseException) {}
            ++i;
        }
        return date;
    }

    public PrincipalCollectionSetProperty principalCollectionSetFindMethod(String path) throws HttpException, IOException {
        this.setClient();
        PrincipalCollectionSetProperty set = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement("principal-collection-set");
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), 0, properties.elements());
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof PrincipalCollectionSetProperty)) continue;
                set = (PrincipalCollectionSetProperty)property;
            }
        }
        return set;
    }

    public Enumeration propfindMethod(int depth) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), depth);
    }

    public Enumeration propfindMethod(int depth, Vector properties) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), depth, properties);
    }

    public Enumeration propfindMethod(String propertyName) throws HttpException, IOException {
        Vector<String> property = new Vector<String>();
        property.addElement(propertyName);
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), property);
    }

    public Enumeration propfindMethod(String path, int depth) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), depth);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        if (this.thisResource) {
            this.setStatusCode(method.getStatusCode());
        }
        this.thisResource = false;
        return method.getResponses();
    }

    public Enumeration propfindMethod(String path, int depth, Vector properties) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), depth, properties.elements());
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        if (this.thisResource) {
            this.setStatusCode(method.getStatusCode());
        }
        this.thisResource = false;
        return method.getResponses();
    }

    public Enumeration propfindMethod(String path, String propertyName) throws HttpException, IOException {
        Vector<String> property = new Vector<String>();
        property.addElement(propertyName);
        this.thisResource = false;
        return this.propfindMethod(GenericURI.getPath(path), property);
    }

    public Enumeration propfindMethod(String path, Vector properties) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(GenericURI.getPath(path), 0, properties.elements());
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                results.addElement(property.getPropertyAsString());
            }
        }
        return results.elements();
    }

    public Enumeration propfindMethod(Vector properties) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), properties);
    }

    public boolean proppatchMethod(String propertyName, String propertyValue) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(String path, String propertyName, String propertyValue) throws HttpException, IOException {
        Hashtable<String, String> property = new Hashtable<String, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property);
    }

    public boolean proppatchMethod(String path, Hashtable properties) throws HttpException, IOException {
        this.setClient();
        PropPatchMethod method = new PropPatchMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        Enumeration names = properties.keys();
        boolean hasSomething = false;
        if (names.hasMoreElements()) {
            hasSomething = true;
        }
        while (names.hasMoreElements()) {
            String name;
            Object item = names.nextElement();
            if (item instanceof String) {
                name = (String)item;
                String value = (String)properties.get(item);
                method.addPropertyToSet(name, value);
                continue;
            }
            if (!(item instanceof PropertyName)) continue;
            name = ((PropertyName)item).getLocalName();
            String namespaceURI = ((PropertyName)item).getNamespaceURI();
            String value = (String)properties.get(item);
            method.addPropertyToSet(name, value, null, namespaceURI);
        }
        if (hasSomething) {
            method.setDebug(this.debug);
            this.client.executeMethod((HttpMethod)method);
            int statusCode = method.getStatusCode();
            this.setStatusCode(statusCode);
            if (statusCode >= 200 && statusCode < 300) {
                return true;
            }
        }
        return false;
    }

    public boolean proppatchMethod(String path, PropertyName propertyName, String propertyValue) throws HttpException, IOException {
        Hashtable<PropertyName, String> property = new Hashtable<PropertyName, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property);
    }

    public boolean proppatchMethod(Hashtable properties) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), properties);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(PropertyName propertyName, String propertyValue) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(File file) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPath(), file);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(InputStream is) throws HttpException, IOException {
        return this.putMethod(this.httpURL.getPathQuery(), is);
    }

    public boolean putMethod(String data) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPath(), data);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(String path, File file) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        method.sendData(file);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(String path, InputStream is) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(GenericURI.getPathQuery(path));
        this.generateIfHeader((HttpMethod)method);
        method.sendData(is);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(String path, String data) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        method.sendData(data);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(String path, URL url) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(GenericURI.getPath(path));
        this.generateIfHeader((HttpMethod)method);
        method.sendData(url);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(String path, byte[] data) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(GenericURI.getPathQuery(path));
        this.generateIfHeader((HttpMethod)method);
        method.sendData(data);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(URL url) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPath(), url);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(byte[] data) throws HttpException, IOException {
        return this.putMethod(this.httpURL.getPathQuery(), data);
    }

    private void refresh() throws HttpException, IOException {
        int latestStatusCode = this.latestStatusCode;
        String latestStatusMessage = this.latestStatusMessage;
        this.setProperties(0);
        this.latestStatusCode = latestStatusCode;
        this.latestStatusMessage = latestStatusMessage;
    }

    public HttpClient retrieveSessionInstance() throws IOException {
        this.setClient();
        return this.client;
    }

    private void setAllProp(int depth) throws HttpException, IOException {
        Enumeration responses = this.propfindMethod(depth);
        this.setWebdavProperties(responses);
    }

    private void setBasicProperties(int depth) throws HttpException, IOException {
        Vector<String> properties = new Vector<String>();
        properties.addElement(DISPLAYNAME);
        properties.addElement(GETCONTENTLENGTH);
        properties.addElement(GETCONTENTTYPE);
        properties.addElement(RESOURCETYPE);
        properties.addElement(GETLASTMODIFIED);
        properties.addElement(LOCKDISCOVERY);
        this.setNamedProp(depth, properties);
    }

    private void setClient() throws IOException {
        this.setClient(this.httpURL);
    }

    private synchronized void setClient(HttpURL httpURL) throws IOException {
        if (this.client == null || this.client != null && !this.isTheClient()) {
            this.closeSession();
            this.client = this.getSessionInstance(httpURL);
        }
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(String creationDate) {
        Date date = this.parseDate(creationDate);
        if (date != null) {
            this.creationDate = date.getTime();
        }
    }

    public static void setDefaultAction(int action) {
        defaultAction = action;
    }

    public static void setDefaultDepth(int depth) {
        defaultDepth = depth;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEncodeURLs(boolean encodeURLs) throws MalformedURLException, IOException {
        State state = this.client.getState();
        if (state != null) {
            state.setEncodeURLs(encodeURLs);
        }
    }

    public void setExistence(boolean exists) {
        this.exists = exists;
    }

    public void setGetContentLength(long getContentLength) {
        this.getContentLength = getContentLength;
    }

    public void setGetContentLength(String getContentLength) {
        try {
            this.getContentLength = Long.parseLong(getContentLength);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setGetContentType(String getContentType) {
        this.getContentType = getContentType;
    }

    public void setGetEtag(String getEtag) {
        this.getEtag = getEtag;
    }

    public void setGetLastModified(long getLastModified) {
        this.getLastModified = getLastModified;
    }

    public void setGetLastModified(String getLastModified) {
        Date date = this.parseDate(getLastModified);
        if (date != null) {
            this.getLastModified = date.getTime();
        }
    }

    public static void setGetTempDir(String tempDir) {
        tempDirForGet = tempDir;
    }

    public static void setGetUseDisk(boolean useDisk) {
        useDiskForGet = useDisk;
    }

    public void setHttpURL(String escapedHttpURL) throws HttpException, IOException {
        this.setHttpURL(new HttpURL(escapedHttpURL));
    }

    public void setHttpURL(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, depth);
    }

    public void setHttpURL(HttpURL httpURL, int action, int depth) throws HttpException, IOException {
        this.httpURL = httpURL;
        this.setClient(httpURL);
        this.setExistence(false);
        this.setProperties(action, depth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath) throws HttpException, IOException {
        this.setHttpURL(new HttpURL(httpURL, additionalPath), defaultAction, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath, int action) throws HttpException, IOException {
        this.setHttpURL(new HttpURL(httpURL, additionalPath), action, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath, int action, int depth) throws HttpException, IOException {
        this.setHttpURL(new HttpURL(httpURL, additionalPath), action, depth);
    }

    public void setIsCollection(String isCollection) {
        this.isCollection = isCollection.equals(TRUE);
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public void setIsHidden(String isHidden) {
        this.isHidden = isHidden.equals(TRUE);
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setLockDiscovery(LockDiscoveryProperty lockDiscovery) {
        this.lockDiscovery = lockDiscovery;
    }

    private void setNameProperties(int depth) throws HttpException, IOException {
        Vector<String> properties = new Vector<String>();
        properties.addElement(DISPLAYNAME);
        this.setNamedProp(depth, properties);
    }

    private void setNamedProp(int depth, Vector propertyNames) throws HttpException, IOException {
        Enumeration responses = this.propfindMethod(depth, propertyNames);
        this.setWebdavProperties(responses);
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setPath(String path) throws HttpException, IOException {
        this.httpURL.setPath(path);
        this.setHttpURL(this.httpURL);
    }

    public void setProperties(int depth) throws HttpException, IOException {
        this.setProperties(defaultAction, depth);
    }

    public void setProperties(int action, int depth) throws HttpException, IOException {
        switch (action) {
            case 2: {
                this.setNameProperties(depth);
            }
            case 3: {
                this.setBasicProperties(depth);
                break;
            }
            case 4: 
            case 5: {
                this.setAllProp(depth);
                break;
            }
        }
    }

    public void setResourceType(ResourceTypeProperty resourceType) {
        this.resourceType = resourceType;
    }

    public void setStatusCode(int statusCode) {
        this.setStatusCode(statusCode, null);
    }

    public void setStatusCode(int statusCode, String message) {
        this.latestStatusCode = statusCode;
        this.latestStatusMessage = String.valueOf(WebdavStatus.getStatusText(statusCode)) + " (" + statusCode + ")" + (message == null ? "" : message);
    }

    public void setSupportedLock(String supportedLock) {
        this.supportedLock = supportedLock;
    }

    public void setUserInfo(String userName, String password) throws HttpException, IOException {
        this.httpURL.setUserInfo(userName, password);
        this.setHttpURL(this.httpURL);
    }

    private void setWebdavProperties(Enumeration responses) throws HttpException, IOException {
        this.childResources.removeAll();
        while (responses.hasMoreElements()) {
            String httpURLPath;
            int compared;
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            boolean itself = false;
            String href = response.getHref();
            if (!href.startsWith("/")) {
                href = GenericURI.getPath(href);
            }
            if ((compared = (httpURLPath = this.httpURL.getPath()).compareToIgnoreCase(href)) == 0 || compared == -1 && href.endsWith("/") || compared == 1 && httpURLPath.endsWith("/")) {
                if (response.getStatusCode() > 0) {
                    this.setStatusCode(response.getStatusCode());
                }
                this.setExistence(true);
                itself = true;
            }
            WebdavResource workingResource = null;
            if (itself) {
                workingResource = this;
            } else {
                workingResource = new WebdavResource(this.client);
                workingResource.setDebug(this.debug);
            }
            String displayName = null;
            workingResource.setLockDiscovery(null);
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                Property property = (Property)properties.nextElement();
                if (property.getLocalName().equals(DISPLAYNAME)) {
                    displayName = property.getPropertyAsString();
                    continue;
                }
                if (property.getLocalName().equals(GETCONTENTLENGTH)) {
                    String getContentLength = property.getPropertyAsString();
                    workingResource.setGetContentLength(getContentLength);
                    continue;
                }
                if (property.getLocalName().equals(RESOURCETYPE)) {
                    ResourceTypeProperty resourceType = (ResourceTypeProperty)property;
                    workingResource.setResourceType(resourceType);
                    continue;
                }
                if (property.getLocalName().equals(GETCONTENTTYPE)) {
                    String getContentType = property.getPropertyAsString();
                    workingResource.setGetContentType(getContentType);
                    continue;
                }
                if (property.getLocalName().equals(GETLASTMODIFIED)) {
                    String getLastModified = property.getPropertyAsString();
                    workingResource.setGetLastModified(getLastModified);
                    continue;
                }
                if (property.getLocalName().equals(CREATIONDATE)) {
                    String creationDate = property.getPropertyAsString();
                    workingResource.setCreationDate(creationDate);
                    continue;
                }
                if (property.getLocalName().equals(GETETAG)) {
                    String getEtag = property.getPropertyAsString();
                    workingResource.setGetEtag(getEtag);
                    continue;
                }
                if (property.getLocalName().equals(ISHIDDEN)) {
                    String isHidden = property.getPropertyAsString();
                    workingResource.setIsHidden(isHidden);
                    continue;
                }
                if (property.getLocalName().equals(ISCOLLECTION)) {
                    String isCollection = property.getPropertyAsString();
                    workingResource.setIsCollection(isCollection);
                    continue;
                }
                if (property.getLocalName().equals(SUPPORTEDLOCK)) {
                    String supportedLock = property.getPropertyAsString();
                    workingResource.setSupportedLock(supportedLock);
                    continue;
                }
                if (!property.getLocalName().equals(LOCKDISCOVERY)) continue;
                LockDiscoveryProperty lockDiscovery = (LockDiscoveryProperty)property;
                workingResource.setLockDiscovery(lockDiscovery);
            }
            if (displayName == null || displayName.trim().equals("")) {
                displayName = HttpURL.getName(href);
            }
            if (!itself) {
                workingResource.setHttpURL(this.httpURL, displayName, 1);
                workingResource.setExistence(true);
                workingResource.setOverwrite(this.getOverwrite());
            }
            workingResource.setDisplayName(displayName);
            if (itself) continue;
            this.childResources.addResource(workingResource);
        }
    }

    public String toString() {
        return this.httpURL.toString();
    }

    public boolean unlockMethod() throws HttpException, IOException {
        boolean result = this.unlockMethod(this.httpURL.getPath());
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean unlockMethod(String path) throws HttpException, IOException {
        this.setClient();
        WebdavState state = (WebdavState)this.client.getState();
        path = GenericURI.getPath(path);
        String lock = state.getLock(path);
        if (lock == null) {
            return false;
        }
        UnlockMethod method = new UnlockMethod(path);
        this.generateIfHeader((HttpMethod)method);
        method.setLockToken(lock);
        method.setDebug(this.debug);
        this.client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            state.removeLocks(path);
            return true;
        }
        return false;
    }
}

