/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.webdav.lib.WebdavResource;

public class WebdavFile
extends File {
    WebdavResource resource = null;

    public WebdavFile(WebdavResource resource) {
        super(resource.getHttpURL().getPath());
        this.resource = resource;
    }

    public boolean canRead() {
        return this.resource.exists() && !this.resource.isCollection();
    }

    public boolean canWrite() {
        return this.resource.exists() && !this.resource.isCollection();
    }

    public int compareTo(File pathname) {
        return 1;
    }

    public int compareTo(Object o) {
        return 1;
    }

    public boolean createNewFile() throws IOException {
        try {
            return this.resource.lockMethod();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean delete() {
        try {
            return this.resource.deleteMethod();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object obj) {
        return false;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public File getAbsoluteFile() {
        return null;
    }

    public String getAbsolutePath() {
        return this.resource.getHttpURL().getPath();
    }

    public File getCanonicalFile() throws IOException {
        return null;
    }

    public String getCanonicalPath() throws IOException {
        return this.resource.getHttpURL().getPath();
    }

    public String getName() {
        return this.resource.getHttpURL().getName();
    }

    public String getParent() {
        return this.resource.getHttpURL().getParent();
    }

    public File getParentFile() {
        return null;
    }

    public String getPath() {
        return this.resource.getHttpURL().getPath();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        return this.resource.isCollection();
    }

    public boolean isFile() {
        return this.resource.isCollection() ^ true;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return this.resource.getGetLastModified();
    }

    public long length() {
        return this.resource.getGetContentLength();
    }

    public String[] list() {
        return this.resource.list();
    }

    public String[] list(FilenameFilter filter) {
        return null;
    }

    public File[] listFiles() {
        return null;
    }

    public File[] listFiles(FileFilter filter) {
        return null;
    }

    public File[] listFiles(FilenameFilter filter) {
        return null;
    }

    public boolean mkdir() {
        try {
            return this.resource.mkcolMethod();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean mkdirs() {
        try {
            return this.resource.mkcolMethod();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean renameTo(File dest) {
        try {
            return this.resource.moveMethod(dest.getPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public String toString() {
        return this.resource.getHttpURL().toString();
    }

    public URL toURL() throws MalformedURLException {
        return this.resource.getHttpURL().toURL();
    }
}

