/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.webdav.lib.Privilege;

public class Ace {
    protected String principal;
    protected boolean negative = false;
    protected Vector privileges = new Vector();
    protected boolean protectedAce = false;
    protected boolean inherited = false;
    protected String inheritedFrom = null;

    public Ace(String principal) {
        this.principal = principal;
    }

    public Ace(String principal, boolean negative, boolean protectedAce, boolean inherited, String inheritedFrom) {
        this(principal);
        this.negative = negative;
        this.protectedAce = protectedAce;
        this.inherited = inherited;
        this.inheritedFrom = inheritedFrom;
    }

    public void addPrivilege(Privilege privilege) {
        this.privileges.addElement(privilege);
    }

    public void clearPrivileges() {
        this.privileges.clear();
    }

    public Enumeration enumeratePrivileges() {
        return this.privileges.elements();
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isProtected() {
        return this.protectedAce;
    }

    public boolean removePrivilege(Privilege privilege) {
        return this.privileges.removeElement(privilege);
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public void setInheritedFrom(String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setProtected(boolean protectedAce) {
        this.protectedAce = protectedAce;
    }

    public String toString() {
        return String.valueOf(!this.isNegative() ? "granted" : "denied") + " to " + this.getPrincipal() + " (" + (this.isProtected() ? "protected" : "not protected") + ")" + " (" + (this.isInherited() ? "inherited from '" + this.getInheritedFrom() + "'" : "not inherited") + ")";
    }
}

