/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtil {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static BitSet alphanum = new BitSet(128);
    private static BitSet schemeReserved;
    private static BitSet authorityReserved;
    private static BitSet userinfoReserved;
    private static BitSet hostReserved;
    private static BitSet pathReserved;
    private static BitSet queryReserved;

    static {
        int i = 97;
        while (i <= 122) {
            alphanum.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            alphanum.set(i2);
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            alphanum.set(i3);
            ++i3;
        }
        schemeReserved = new BitSet(128);
        schemeReserved.set(43);
        schemeReserved.set(46);
        schemeReserved.set(45);
        authorityReserved = new BitSet(128);
        authorityReserved.set(59);
        authorityReserved.set(58);
        authorityReserved.set(64);
        authorityReserved.set(63);
        authorityReserved.set(47);
        userinfoReserved = new BitSet(128);
        userinfoReserved.set(59);
        userinfoReserved.set(58);
        userinfoReserved.set(38);
        userinfoReserved.set(61);
        userinfoReserved.set(43);
        userinfoReserved.set(36);
        userinfoReserved.set(44);
        hostReserved = new BitSet(128);
        hostReserved.set(46);
        hostReserved.set(45);
        pathReserved = new BitSet(128);
        pathReserved.set(47);
        pathReserved.set(59);
        pathReserved.set(61);
        pathReserved.set(63);
        queryReserved = new BitSet(128);
        queryReserved.set(59);
        queryReserved.set(47);
        queryReserved.set(63);
        queryReserved.set(58);
        queryReserved.set(64);
        queryReserved.set(38);
        queryReserved.set(61);
        queryReserved.set(43);
        queryReserved.set(44);
        queryReserved.set(36);
    }

    public static BitSet alphanum() {
        return alphanum;
    }

    public static BitSet authorityReserved() {
        return authorityReserved;
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static String escape(String str) {
        return URIUtil.escape(str, null);
    }

    public static String escape(String str, BitSet reserved) {
        return str == null ? null : URIUtil.escape(str.getBytes(), reserved);
    }

    public static String escape(String str, BitSet reserved, String enc) {
        try {
            return URIUtil.escape(str.getBytes(enc), reserved);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return URIUtil.escape(str.getBytes(), reserved);
        }
    }

    public static String escape(byte[] bytes, BitSet reserved) {
        if (bytes == null) {
            return null;
        }
        StringBuffer rewrittenStr = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            char c = (char)bytes[i];
            if (alphanum.get(c)) {
                rewrittenStr.append(c);
            } else if (reserved != null && reserved.get(c)) {
                rewrittenStr.append(c);
            } else {
                byte toEscape = bytes[i];
                rewrittenStr.append('%');
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                rewrittenStr.append(hexadecimal[high]);
                rewrittenStr.append(hexadecimal[low]);
            }
            ++i;
        }
        return rewrittenStr.toString();
    }

    public static BitSet hostReserved() {
        return hostReserved;
    }

    public static BitSet pathReserved() {
        return pathReserved;
    }

    public static BitSet queryReserved() {
        return queryReserved;
    }

    public static BitSet schemeReserved() {
        return schemeReserved;
    }

    public static String unescape(String str) {
        return str == null ? null : URIUtil.unescape(str.getBytes());
    }

    public static String unescape(byte[] bytes) {
        return URIUtil.unescape(bytes, null);
    }

    public static String unescape(byte[] bytes, String enc) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        int ix = 0;
        int ox = 0;
        while (ix < len) {
            int b;
            if ((b = bytes[ix++]) == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((URIUtil.convertHexDigit(bytes[ix++]) << 4) + URIUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        if (enc != null) {
            try {
                return new String(bytes, 0, ox, enc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return new String(bytes, 0, ox);
    }

    public static BitSet userinfoReserved() {
        return userinfoReserved;
    }
}

