/*
 * Decompiled with CFR 0.152.
 */
package skin.support.utils;

import android.graphics.drawable.Drawable;
import java.lang.reflect.Method;
import skin.support.utils.Slog;

public final class SkinCompatVersionUtils {
    private static final String TAG = "SkinCompatUtils";
    private static Class<?> sV4DrawableWrapperClass;
    private static Method sV4DrawableWrapperGetM;
    private static Method sV4DrawableWrapperSetM;
    private static Class<?> sV4WrappedDrawableClass;
    private static Method sV4WrappedDrawableGetM;
    private static Method sV4WrappedDrawableSetM;
    private static Class<?> sV7DrawableWrapperClass;
    private static Method sV7DrawableWrapperGetM;
    private static Method sV7DrawableWrapperSetM;

    public static boolean hasV4WrappedDrawable() {
        return sV4WrappedDrawableClass != null;
    }

    public static boolean isV4WrappedDrawable(Drawable drawable) {
        return sV4WrappedDrawableClass != null && sV4WrappedDrawableClass.isAssignableFrom(drawable.getClass());
    }

    public static Drawable getV4WrappedDrawableWrappedDrawable(Drawable drawable) {
        block8: {
            if (sV4WrappedDrawableClass != null) {
                block7: {
                    if (sV4WrappedDrawableGetM == null) {
                        try {
                            sV4WrappedDrawableGetM = sV4WrappedDrawableClass.getDeclaredMethod("getWrappedDrawable", new Class[0]);
                            sV4WrappedDrawableGetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "getV4WrappedDrawableWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4WrappedDrawableGetM != null) {
                    try {
                        return (Drawable)sV4WrappedDrawableGetM.invoke((Object)drawable, new Object[0]);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "getV4WrappedDrawableWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
        return drawable;
    }

    public static void setV4WrappedDrawableWrappedDrawable(Drawable drawable, Drawable inner) {
        block8: {
            if (sV4WrappedDrawableClass != null) {
                block7: {
                    if (sV4WrappedDrawableSetM == null) {
                        try {
                            sV4WrappedDrawableSetM = sV4WrappedDrawableClass.getDeclaredMethod("setWrappedDrawable", Drawable.class);
                            sV4WrappedDrawableSetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "setV4WrappedDrawableWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4WrappedDrawableSetM != null) {
                    try {
                        sV4WrappedDrawableSetM.invoke((Object)drawable, inner);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "setV4WrappedDrawableWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
    }

    public static boolean hasV4DrawableWrapper() {
        return sV4DrawableWrapperClass != null;
    }

    public static boolean isV4DrawableWrapper(Drawable drawable) {
        return sV4DrawableWrapperClass != null && sV4DrawableWrapperClass.isAssignableFrom(drawable.getClass());
    }

    public static Drawable getV4DrawableWrapperWrappedDrawable(Drawable drawable) {
        block8: {
            if (sV4DrawableWrapperClass != null) {
                block7: {
                    if (sV4DrawableWrapperGetM == null) {
                        try {
                            sV4DrawableWrapperGetM = sV4DrawableWrapperClass.getDeclaredMethod("getWrappedDrawable", new Class[0]);
                            sV4DrawableWrapperGetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "getV4DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4DrawableWrapperGetM != null) {
                    try {
                        return (Drawable)sV4DrawableWrapperGetM.invoke((Object)drawable, new Object[0]);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "getV4DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
        return drawable;
    }

    public static void setV4DrawableWrapperWrappedDrawable(Drawable drawable, Drawable inner) {
        block8: {
            if (sV4DrawableWrapperClass != null) {
                block7: {
                    if (sV4DrawableWrapperSetM == null) {
                        try {
                            sV4DrawableWrapperSetM = sV4DrawableWrapperClass.getDeclaredMethod("setWrappedDrawable", Drawable.class);
                            sV4DrawableWrapperSetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "setV4DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4DrawableWrapperSetM != null) {
                    try {
                        sV4DrawableWrapperSetM.invoke((Object)drawable, inner);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "setV4DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
    }

    public static boolean hasV7DrawableWrapper() {
        return sV7DrawableWrapperClass != null;
    }

    public static boolean isV7DrawableWrapper(Drawable drawable) {
        return sV7DrawableWrapperClass != null && sV7DrawableWrapperClass.isAssignableFrom(drawable.getClass());
    }

    public static Drawable getV7DrawableWrapperWrappedDrawable(Drawable drawable) {
        block8: {
            if (sV7DrawableWrapperClass != null) {
                block7: {
                    if (sV7DrawableWrapperGetM == null) {
                        try {
                            sV7DrawableWrapperGetM = sV7DrawableWrapperClass.getDeclaredMethod("getWrappedDrawable", new Class[0]);
                            sV7DrawableWrapperGetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "getV7DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV7DrawableWrapperGetM != null) {
                    try {
                        return (Drawable)sV7DrawableWrapperGetM.invoke((Object)drawable, new Object[0]);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "getV7DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
        return drawable;
    }

    public static void setV7DrawableWrapperWrappedDrawable(Drawable drawable, Drawable inner) {
        block8: {
            if (sV7DrawableWrapperClass != null) {
                block7: {
                    if (sV7DrawableWrapperSetM == null) {
                        try {
                            sV7DrawableWrapperSetM = sV7DrawableWrapperClass.getDeclaredMethod("setWrappedDrawable", Drawable.class);
                            sV7DrawableWrapperSetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "setV7DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV7DrawableWrapperSetM != null) {
                    try {
                        sV7DrawableWrapperSetM.invoke((Object)drawable, inner);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "setV7DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
    }

    static {
        block8: {
            block7: {
                block6: {
                    try {
                        sV4WrappedDrawableClass = Class.forName("android.support.v4.graphics.drawable.WrappedDrawable");
                    }
                    catch (ClassNotFoundException e) {
                        if (!Slog.DEBUG) break block6;
                        Slog.i(TAG, "hasV4WrappedDrawable = false");
                    }
                }
                try {
                    sV4DrawableWrapperClass = Class.forName("android.support.v4.graphics.drawable.DrawableWrapper");
                }
                catch (ClassNotFoundException e) {
                    if (!Slog.DEBUG) break block7;
                    Slog.i(TAG, "hasV4DrawableWrapper = false");
                }
            }
            try {
                sV7DrawableWrapperClass = Class.forName("android.support.v7.graphics.drawable.DrawableWrapper");
            }
            catch (ClassNotFoundException e) {
                if (!Slog.DEBUG) break block8;
                Slog.i(TAG, "hasV7DrawableWrapper = false");
            }
        }
    }
}

