/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.TypedValue;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.ColorUtils;
import skin.support.content.res.SkinCompatResources;

public class SkinCompatThemeUtils {
    private static final ThreadLocal<TypedValue> TL_TYPED_VALUE = new ThreadLocal();
    static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    static final int[] ENABLED_STATE_SET = new int[]{16842910};
    static final int[] WINDOW_FOCUSED_STATE_SET = new int[]{16842909};
    static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    static final int[] ACTIVATED_STATE_SET = new int[]{16843518};
    static final int[] ACCELERATED_STATE_SET = new int[]{16843547};
    static final int[] HOVERED_STATE_SET = new int[]{16843623};
    static final int[] DRAG_CAN_ACCEPT_STATE_SET = new int[]{16843624};
    static final int[] DRAG_HOVERED_STATE_SET = new int[]{16843625};
    static final int[] PRESSED_STATE_SET = new int[]{16842919};
    static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    static final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    static final int[] NOT_PRESSED_OR_FOCUSED_STATE_SET = new int[]{-16842919, -16842908};
    static final int[] EMPTY_STATE_SET = new int[0];
    private static final int[] TEMP_ARRAY = new int[1];

    public static int getTextColorPrimaryResId(Context context) {
        return SkinCompatThemeUtils.getResId(context, new int[]{16842806});
    }

    @RequiresApi(api=21)
    public static int getStatusBarColorResId(Context context) {
        return SkinCompatThemeUtils.getResId(context, new int[]{16843857});
    }

    public static int getWindowBackgroundResId(Context context) {
        return SkinCompatThemeUtils.getResId(context, new int[]{16842836});
    }

    static int getResId(Context context, int[] attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs);
        int resId = a.getResourceId(0, 0);
        a.recycle();
        return resId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttrColor(Context context, int attr2) {
        SkinCompatThemeUtils.TEMP_ARRAY[0] = attr2;
        TypedArray a = context.obtainStyledAttributes(null, TEMP_ARRAY);
        try {
            int resId = a.getResourceId(0, 0);
            if (resId != 0) {
                int n = SkinCompatResources.getColor(context, resId);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getThemeAttrColorStateList(Context context, int attr2) {
        SkinCompatThemeUtils.TEMP_ARRAY[0] = attr2;
        TypedArray a = context.obtainStyledAttributes(null, TEMP_ARRAY);
        try {
            int resId = a.getResourceId(0, 0);
            if (resId != 0) {
                ColorStateList colorStateList = SkinCompatResources.getColorStateList(context, resId);
                return colorStateList;
            }
            ColorStateList colorStateList = null;
            return colorStateList;
        }
        finally {
            a.recycle();
        }
    }

    public static int getDisabledThemeAttrColor(Context context, int attr2) {
        ColorStateList csl = SkinCompatThemeUtils.getThemeAttrColorStateList(context, attr2);
        if (csl != null && csl.isStateful()) {
            return csl.getColorForState(DISABLED_STATE_SET, csl.getDefaultColor());
        }
        TypedValue tv = SkinCompatThemeUtils.getTypedValue();
        context.getTheme().resolveAttribute(0x1010033, tv, true);
        float disabledAlpha = tv.getFloat();
        return SkinCompatThemeUtils.getThemeAttrColor(context, attr2, disabledAlpha);
    }

    private static TypedValue getTypedValue() {
        TypedValue typedValue = TL_TYPED_VALUE.get();
        if (typedValue == null) {
            typedValue = new TypedValue();
            TL_TYPED_VALUE.set(typedValue);
        }
        return typedValue;
    }

    static int getThemeAttrColor(Context context, int attr2, float alpha) {
        int color = SkinCompatThemeUtils.getThemeAttrColor(context, attr2);
        int originalAlpha = Color.alpha((int)color);
        return ColorUtils.setAlphaComponent((int)color, (int)Math.round((float)originalAlpha * alpha));
    }
}

