/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.text.TextUtils;
import androidx.annotation.ColorRes;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import skin.support.content.res.SkinCompatThemeUtils;
import skin.support.content.res.SkinCompatUserThemeManager;
import skin.support.exception.SkinCompatException;
import skin.support.utils.Slog;

public final class ColorState {
    private static final String TAG = "ColorState";
    boolean onlyDefaultColor;
    String colorName;
    String colorWindowFocused;
    String colorSelected;
    String colorFocused;
    String colorEnabled;
    String colorPressed;
    String colorChecked;
    String colorActivated;
    String colorAccelerated;
    String colorHovered;
    String colorDragCanAccept;
    String colorDragHovered;
    String colorDefault;

    ColorState(String colorWindowFocused, String colorSelected, String colorFocused, String colorEnabled, String colorPressed, String colorChecked, String colorActivated, String colorAccelerated, String colorHovered, String colorDragCanAccept, String colorDragHovered, String colorDefault) {
        this.colorWindowFocused = colorWindowFocused;
        this.colorSelected = colorSelected;
        this.colorFocused = colorFocused;
        this.colorEnabled = colorEnabled;
        this.colorPressed = colorPressed;
        this.colorChecked = colorChecked;
        this.colorActivated = colorActivated;
        this.colorAccelerated = colorAccelerated;
        this.colorHovered = colorHovered;
        this.colorDragCanAccept = colorDragCanAccept;
        this.colorDragHovered = colorDragHovered;
        this.colorDefault = colorDefault;
        boolean bl = this.onlyDefaultColor = TextUtils.isEmpty((CharSequence)colorWindowFocused) && TextUtils.isEmpty((CharSequence)colorSelected) && TextUtils.isEmpty((CharSequence)colorFocused) && TextUtils.isEmpty((CharSequence)colorEnabled) && TextUtils.isEmpty((CharSequence)colorPressed) && TextUtils.isEmpty((CharSequence)colorChecked) && TextUtils.isEmpty((CharSequence)colorActivated) && TextUtils.isEmpty((CharSequence)colorAccelerated) && TextUtils.isEmpty((CharSequence)colorHovered) && TextUtils.isEmpty((CharSequence)colorDragCanAccept) && TextUtils.isEmpty((CharSequence)colorDragHovered);
        if (this.onlyDefaultColor && !colorDefault.startsWith("#")) {
            throw new SkinCompatException("Default color cannot be a reference, when only default color is available!");
        }
    }

    ColorState(String colorName, String colorDefault) {
        this.colorName = colorName;
        this.colorDefault = colorDefault;
        this.onlyDefaultColor = true;
        if (!colorDefault.startsWith("#")) {
            throw new SkinCompatException("Default color cannot be a reference, when only default color is available!");
        }
    }

    public boolean isOnlyDefaultColor() {
        return this.onlyDefaultColor;
    }

    public String getColorName() {
        return this.colorName;
    }

    public String getColorWindowFocused() {
        return this.colorWindowFocused;
    }

    public String getColorSelected() {
        return this.colorSelected;
    }

    public String getColorFocused() {
        return this.colorFocused;
    }

    public String getColorEnabled() {
        return this.colorEnabled;
    }

    public String getColorPressed() {
        return this.colorPressed;
    }

    public String getColorChecked() {
        return this.colorChecked;
    }

    public String getColorActivated() {
        return this.colorActivated;
    }

    public String getColorAccelerated() {
        return this.colorAccelerated;
    }

    public String getColorHovered() {
        return this.colorHovered;
    }

    public String getColorDragCanAccept() {
        return this.colorDragCanAccept;
    }

    public String getColorDragHovered() {
        return this.colorDragHovered;
    }

    public String getColorDefault() {
        return this.colorDefault;
    }

    ColorStateList parse() {
        if (this.onlyDefaultColor) {
            int defaultColor = Color.parseColor((String)this.colorDefault);
            return ColorStateList.valueOf((int)defaultColor);
        }
        return this.parseAll();
    }

    private ColorStateList parseAll() {
        int stateColorCount = 0;
        ArrayList<int[]> stateSetList = new ArrayList<int[]>();
        ArrayList<Integer> stateColorList = new ArrayList<Integer>();
        if (!TextUtils.isEmpty((CharSequence)this.colorWindowFocused)) {
            try {
                String windowFocusedColorStr = this.getColorStr(this.colorWindowFocused);
                if (!TextUtils.isEmpty((CharSequence)windowFocusedColorStr)) {
                    int windowFocusedColorInt = Color.parseColor((String)windowFocusedColorStr);
                    stateSetList.add(SkinCompatThemeUtils.WINDOW_FOCUSED_STATE_SET);
                    stateColorList.add(windowFocusedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception windowFocusedColorStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorSelected)) {
            try {
                String colorSelectedStr = this.getColorStr(this.colorSelected);
                if (!TextUtils.isEmpty((CharSequence)colorSelectedStr)) {
                    int selectedColorInt = Color.parseColor((String)colorSelectedStr);
                    stateSetList.add(SkinCompatThemeUtils.SELECTED_STATE_SET);
                    stateColorList.add(selectedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorSelectedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorFocused)) {
            try {
                String colorFocusedStr = this.getColorStr(this.colorFocused);
                if (!TextUtils.isEmpty((CharSequence)colorFocusedStr)) {
                    int focusedColorInt = Color.parseColor((String)colorFocusedStr);
                    stateSetList.add(SkinCompatThemeUtils.FOCUSED_STATE_SET);
                    stateColorList.add(focusedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorFocusedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorEnabled)) {
            try {
                String colorEnabledStr = this.getColorStr(this.colorEnabled);
                if (!TextUtils.isEmpty((CharSequence)colorEnabledStr)) {
                    int enabledColorInt = Color.parseColor((String)colorEnabledStr);
                    stateSetList.add(SkinCompatThemeUtils.ENABLED_STATE_SET);
                    stateColorList.add(enabledColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorEnabledStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorPressed)) {
            try {
                String colorPressedStr = this.getColorStr(this.colorPressed);
                if (!TextUtils.isEmpty((CharSequence)colorPressedStr)) {
                    int pressedColorInt = Color.parseColor((String)colorPressedStr);
                    stateSetList.add(SkinCompatThemeUtils.PRESSED_STATE_SET);
                    stateColorList.add(pressedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorPressedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorChecked)) {
            try {
                String colorCheckedStr = this.getColorStr(this.colorChecked);
                if (!TextUtils.isEmpty((CharSequence)colorCheckedStr)) {
                    int checkedColorInt = Color.parseColor((String)colorCheckedStr);
                    stateSetList.add(SkinCompatThemeUtils.CHECKED_STATE_SET);
                    stateColorList.add(checkedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorCheckedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorActivated)) {
            try {
                String colorActivatedStr = this.getColorStr(this.colorActivated);
                if (!TextUtils.isEmpty((CharSequence)colorActivatedStr)) {
                    int activatedColorInt = Color.parseColor((String)colorActivatedStr);
                    stateSetList.add(SkinCompatThemeUtils.ACTIVATED_STATE_SET);
                    stateColorList.add(activatedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorActivatedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorAccelerated)) {
            try {
                String colorAcceleratedStr = this.getColorStr(this.colorAccelerated);
                if (!TextUtils.isEmpty((CharSequence)colorAcceleratedStr)) {
                    int acceleratedColorInt = Color.parseColor((String)colorAcceleratedStr);
                    stateSetList.add(SkinCompatThemeUtils.ACCELERATED_STATE_SET);
                    stateColorList.add(acceleratedColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorAcceleratedStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorHovered)) {
            try {
                String colorHoveredStr = this.getColorStr(this.colorHovered);
                if (!TextUtils.isEmpty((CharSequence)colorHoveredStr)) {
                    int hoveredColorInt = Color.parseColor((String)colorHoveredStr);
                    stateSetList.add(SkinCompatThemeUtils.HOVERED_STATE_SET);
                    stateColorList.add(hoveredColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorHoveredStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorDragCanAccept)) {
            try {
                String colorDragCanAcceptStr = this.getColorStr(this.colorDragCanAccept);
                if (!TextUtils.isEmpty((CharSequence)colorDragCanAcceptStr)) {
                    int dragCanAcceptColorInt = Color.parseColor((String)colorDragCanAcceptStr);
                    stateSetList.add(SkinCompatThemeUtils.DRAG_CAN_ACCEPT_STATE_SET);
                    stateColorList.add(dragCanAcceptColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorDragCanAcceptStr) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.colorDragHovered)) {
            try {
                String colorDragHoveredStr = this.getColorStr(this.colorDragHovered);
                if (!TextUtils.isEmpty((CharSequence)colorDragHoveredStr)) {
                    int dragHoveredColorInt = Color.parseColor((String)colorDragHoveredStr);
                    stateSetList.add(SkinCompatThemeUtils.DRAG_HOVERED_STATE_SET);
                    stateColorList.add(dragHoveredColorInt);
                    ++stateColorCount;
                }
            }
            catch (Exception colorDragHoveredStr) {
                // empty catch block
            }
        }
        try {
            String colorDefaultStr = this.getColorStr(this.colorDefault);
            if (!TextUtils.isEmpty((CharSequence)colorDefaultStr)) {
                int baseColor = Color.parseColor((String)colorDefaultStr);
                stateSetList.add(SkinCompatThemeUtils.EMPTY_STATE_SET);
                stateColorList.add(baseColor);
                ++stateColorCount;
            }
            int[][] states = new int[stateColorCount][];
            int[] colors = new int[stateColorCount];
            for (int index = 0; index < stateColorCount; ++index) {
                states[index] = (int[])stateSetList.get(index);
                colors[index] = (Integer)stateColorList.get(index);
            }
            return new ColorStateList((int[][])states, colors);
        }
        catch (Exception e) {
            if (Slog.DEBUG) {
                Slog.i(TAG, this.colorName + " parse failure.");
            }
            SkinCompatUserThemeManager.get().removeColorState(this.colorName);
            return null;
        }
    }

    private String getColorStr(String colorName) {
        if (colorName.startsWith("#")) {
            return colorName;
        }
        ColorState stateRef = SkinCompatUserThemeManager.get().getColorState(colorName);
        if (stateRef != null) {
            if (stateRef.isOnlyDefaultColor()) {
                return stateRef.colorDefault;
            }
            if (Slog.DEBUG) {
                Slog.i(TAG, colorName + " cannot reference " + stateRef.colorName);
            }
        }
        return null;
    }

    static boolean checkColorValid(String name, String color) {
        boolean colorValid;
        boolean bl = colorValid = !TextUtils.isEmpty((CharSequence)color) && (!color.startsWith("#") || color.length() == 7 || color.length() == 9);
        if (Slog.DEBUG && !colorValid) {
            Slog.i(TAG, "Invalid color -> " + name + ": " + color);
        }
        return colorValid;
    }

    static JSONObject toJSONObject(ColorState state) throws JSONException {
        JSONObject object = new JSONObject();
        if (state.onlyDefaultColor) {
            object.putOpt("colorName", (Object)state.colorName).putOpt("colorDefault", (Object)state.colorDefault).putOpt("onlyDefaultColor", (Object)state.onlyDefaultColor);
        } else {
            object.putOpt("colorName", (Object)state.colorName).putOpt("colorWindowFocused", (Object)state.colorWindowFocused).putOpt("colorSelected", (Object)state.colorSelected).putOpt("colorFocused", (Object)state.colorFocused).putOpt("colorEnabled", (Object)state.colorEnabled).putOpt("colorPressed", (Object)state.colorPressed).putOpt("colorChecked", (Object)state.colorChecked).putOpt("colorActivated", (Object)state.colorActivated).putOpt("colorAccelerated", (Object)state.colorAccelerated).putOpt("colorHovered", (Object)state.colorHovered).putOpt("colorDragCanAccept", (Object)state.colorDragCanAccept).putOpt("colorDragHovered", (Object)state.colorDragHovered).putOpt("colorDefault", (Object)state.colorDefault).putOpt("onlyDefaultColor", (Object)state.onlyDefaultColor);
        }
        return object;
    }

    static ColorState fromJSONObject(JSONObject jsonObject) {
        if (jsonObject.has("colorName") && jsonObject.has("colorDefault") && jsonObject.has("onlyDefaultColor")) {
            try {
                boolean onlyDefaultColor = jsonObject.getBoolean("onlyDefaultColor");
                String colorName = jsonObject.getString("colorName");
                String colorDefault = jsonObject.getString("colorDefault");
                if (onlyDefaultColor) {
                    return new ColorState(colorName, colorDefault);
                }
                ColorBuilder builder = new ColorBuilder();
                builder.setColorDefault(colorDefault);
                if (jsonObject.has("colorWindowFocused")) {
                    builder.setColorWindowFocused(jsonObject.getString("colorWindowFocused"));
                }
                if (jsonObject.has("colorSelected")) {
                    builder.setColorSelected(jsonObject.getString("colorSelected"));
                }
                if (jsonObject.has("colorFocused")) {
                    builder.setColorFocused(jsonObject.getString("colorFocused"));
                }
                if (jsonObject.has("colorEnabled")) {
                    builder.setColorEnabled(jsonObject.getString("colorEnabled"));
                }
                if (jsonObject.has("colorPressed")) {
                    builder.setColorPressed(jsonObject.getString("colorPressed"));
                }
                if (jsonObject.has("colorChecked")) {
                    builder.setColorChecked(jsonObject.getString("colorChecked"));
                }
                if (jsonObject.has("colorActivated")) {
                    builder.setColorActivated(jsonObject.getString("colorActivated"));
                }
                if (jsonObject.has("colorAccelerated")) {
                    builder.setColorAccelerated(jsonObject.getString("colorAccelerated"));
                }
                if (jsonObject.has("colorHovered")) {
                    builder.setColorHovered(jsonObject.getString("colorHovered"));
                }
                if (jsonObject.has("colorDragCanAccept")) {
                    builder.setColorDragCanAccept(jsonObject.getString("colorDragCanAccept"));
                }
                if (jsonObject.has("colorDragHovered")) {
                    builder.setColorDragHovered(jsonObject.getString("colorDragHovered"));
                }
                ColorState state = builder.build();
                state.colorName = colorName;
                return state;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class ColorBuilder {
        String colorWindowFocused;
        String colorSelected;
        String colorFocused;
        String colorEnabled;
        String colorPressed;
        String colorChecked;
        String colorActivated;
        String colorAccelerated;
        String colorHovered;
        String colorDragCanAccept;
        String colorDragHovered;
        String colorDefault;

        public ColorBuilder() {
        }

        public ColorBuilder(ColorState state) {
            this.colorWindowFocused = state.colorWindowFocused;
            this.colorSelected = state.colorSelected;
            this.colorFocused = state.colorFocused;
            this.colorEnabled = state.colorEnabled;
            this.colorPressed = state.colorPressed;
            this.colorChecked = state.colorChecked;
            this.colorActivated = state.colorActivated;
            this.colorAccelerated = state.colorAccelerated;
            this.colorHovered = state.colorHovered;
            this.colorDragCanAccept = state.colorDragCanAccept;
            this.colorDragHovered = state.colorDragHovered;
            this.colorDefault = state.colorDefault;
        }

        public ColorBuilder setColorWindowFocused(String colorWindowFocused) {
            if (ColorState.checkColorValid("colorWindowFocused", colorWindowFocused)) {
                this.colorWindowFocused = colorWindowFocused;
            }
            return this;
        }

        public ColorBuilder setColorWindowFocused(Context context, @ColorRes int colorRes) {
            this.colorWindowFocused = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorSelected(String colorSelected) {
            if (ColorState.checkColorValid("colorSelected", colorSelected)) {
                this.colorSelected = colorSelected;
            }
            return this;
        }

        public ColorBuilder setColorSelected(Context context, @ColorRes int colorRes) {
            this.colorSelected = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorFocused(String colorFocused) {
            if (ColorState.checkColorValid("colorFocused", colorFocused)) {
                this.colorFocused = colorFocused;
            }
            return this;
        }

        public ColorBuilder setColorFocused(Context context, @ColorRes int colorRes) {
            this.colorFocused = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorEnabled(String colorEnabled) {
            if (ColorState.checkColorValid("colorEnabled", colorEnabled)) {
                this.colorEnabled = colorEnabled;
            }
            return this;
        }

        public ColorBuilder setColorEnabled(Context context, @ColorRes int colorRes) {
            this.colorEnabled = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorChecked(String colorChecked) {
            if (ColorState.checkColorValid("colorChecked", colorChecked)) {
                this.colorChecked = colorChecked;
            }
            return this;
        }

        public ColorBuilder setColorChecked(Context context, @ColorRes int colorRes) {
            this.colorChecked = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorPressed(String colorPressed) {
            if (ColorState.checkColorValid("colorPressed", colorPressed)) {
                this.colorPressed = colorPressed;
            }
            return this;
        }

        public ColorBuilder setColorPressed(Context context, @ColorRes int colorRes) {
            this.colorPressed = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorActivated(String colorActivated) {
            if (ColorState.checkColorValid("colorActivated", colorActivated)) {
                this.colorActivated = colorActivated;
            }
            return this;
        }

        public ColorBuilder setColorActivated(Context context, @ColorRes int colorRes) {
            this.colorActivated = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorAccelerated(String colorAccelerated) {
            if (ColorState.checkColorValid("colorAccelerated", colorAccelerated)) {
                this.colorAccelerated = colorAccelerated;
            }
            return this;
        }

        public ColorBuilder setColorAccelerated(Context context, @ColorRes int colorRes) {
            this.colorAccelerated = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorHovered(String colorHovered) {
            if (ColorState.checkColorValid("colorHovered", colorHovered)) {
                this.colorHovered = colorHovered;
            }
            return this;
        }

        public ColorBuilder setColorHovered(Context context, @ColorRes int colorRes) {
            this.colorHovered = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorDragCanAccept(String colorDragCanAccept) {
            if (ColorState.checkColorValid("colorDragCanAccept", colorDragCanAccept)) {
                this.colorDragCanAccept = colorDragCanAccept;
            }
            return this;
        }

        public ColorBuilder setColorDragCanAccept(Context context, @ColorRes int colorRes) {
            this.colorDragCanAccept = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorDragHovered(String colorDragHovered) {
            if (ColorState.checkColorValid("colorDragHovered", colorDragHovered)) {
                this.colorDragHovered = colorDragHovered;
            }
            return this;
        }

        public ColorBuilder setColorDragHovered(Context context, @ColorRes int colorRes) {
            this.colorDragHovered = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorBuilder setColorDefault(String colorDefault) {
            if (ColorState.checkColorValid("colorDefault", colorDefault)) {
                this.colorDefault = colorDefault;
            }
            return this;
        }

        public ColorBuilder setColorDefault(Context context, @ColorRes int colorRes) {
            this.colorDefault = context.getResources().getResourceEntryName(colorRes);
            return this;
        }

        public ColorState build() {
            if (TextUtils.isEmpty((CharSequence)this.colorDefault)) {
                throw new SkinCompatException("Default color can not empty!");
            }
            return new ColorState(this.colorWindowFocused, this.colorSelected, this.colorFocused, this.colorEnabled, this.colorPressed, this.colorChecked, this.colorActivated, this.colorAccelerated, this.colorHovered, this.colorDragCanAccept, this.colorDragHovered, this.colorDefault);
        }
    }
}

