/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import skin.support.SkinCompatManager;
import skin.support.app.SkinLayoutInflater;

public class SkinCompatViewInflater {
    private static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final int[] sOnClickAttrs = new int[]{16843375};
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.view.", "android.webkit."};
    private static final Map<String, Constructor<? extends View>> sConstructorMap = new ArrayMap();
    private final Object[] mConstructorArgs = new Object[2];

    public final View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        View view = this.createViewFromHackInflater(context, name, attrs);
        if (view == null) {
            view = this.createViewFromInflater(context, name, attrs);
        }
        if (view == null) {
            view = this.createViewFromTag(context, name, attrs);
        }
        if (view != null) {
            this.checkOnClickListener(view, attrs);
        }
        return view;
    }

    private View createViewFromHackInflater(Context context, String name, AttributeSet attrs) {
        SkinLayoutInflater inflater;
        View view = null;
        Iterator<SkinLayoutInflater> iterator = SkinCompatManager.getInstance().getHookInflaters().iterator();
        while (iterator.hasNext() && (view = (inflater = iterator.next()).createView(context, name, attrs)) == null) {
        }
        return view;
    }

    private View createViewFromInflater(Context context, String name, AttributeSet attrs) {
        SkinLayoutInflater inflater;
        View view = null;
        Iterator<SkinLayoutInflater> iterator = SkinCompatManager.getInstance().getInflaters().iterator();
        while (iterator.hasNext() && (view = (inflater = iterator.next()).createView(context, name, attrs)) == null) {
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if ("view".equals(name)) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            this.mConstructorArgs[0] = context;
            this.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                for (int i = 0; i < sClassPrefixList.length; ++i) {
                    View view = this.createView(context, name, sClassPrefixList[i]);
                    if (view == null) continue;
                    View view2 = view;
                    return view2;
                }
                View i = null;
                return i;
            }
            View i = this.createView(context, name, null);
            return i;
        }
        catch (Exception e) {
            View view = null;
            return view;
        }
        finally {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
        }
    }

    private void checkOnClickListener(View view, AttributeSet attrs) {
        Context context = view.getContext();
        if (!(context instanceof ContextWrapper) || Build.VERSION.SDK_INT >= 15 && !ViewCompat.hasOnClickListeners((View)view)) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, sOnClickAttrs);
        String handlerName = a.getString(0);
        if (handlerName != null) {
            view.setOnClickListener((View.OnClickListener)new DeclaredOnClickListener(view, handlerName));
        }
        a.recycle();
    }

    private View createView(Context context, String name, String prefix) throws ClassNotFoundException, InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<View> clazz = context.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(this.mConstructorArgs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class DeclaredOnClickListener
    implements View.OnClickListener {
        private final View mHostView;
        private final String mMethodName;
        private Method mResolvedMethod;
        private Context mResolvedContext;

        public DeclaredOnClickListener(@NonNull View hostView, @NonNull String methodName) {
            this.mHostView = hostView;
            this.mMethodName = methodName;
        }

        public void onClick(@NonNull View v) {
            if (this.mResolvedMethod == null) {
                this.resolveMethod(this.mHostView.getContext(), this.mMethodName);
            }
            try {
                this.mResolvedMethod.invoke((Object)this.mResolvedContext, v);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not execute non-public method for android:onClick", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not execute method for android:onClick", e);
            }
        }

        @NonNull
        private void resolveMethod(@Nullable Context context, @NonNull String name) {
            while (context != null) {
                try {
                    Method method;
                    if (!context.isRestricted() && (method = context.getClass().getMethod(this.mMethodName, View.class)) != null) {
                        this.mResolvedMethod = method;
                        this.mResolvedContext = context;
                        return;
                    }
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
                if (context instanceof ContextWrapper) {
                    context = ((ContextWrapper)context).getBaseContext();
                    continue;
                }
                context = null;
            }
            int id = this.mHostView.getId();
            String idText = id == -1 ? "" : " with id '" + this.mHostView.getContext().getResources().getResourceEntryName(id) + "'";
            throw new IllegalStateException("Could not find method " + this.mMethodName + "(View) in a parent or ancestor Context for android:onClick attribute defined on view " + this.mHostView.getClass() + idText);
        }
    }
}

