/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import skin.support.SkinCompatManager;
import skin.support.app.SkinCompatViewInflater;
import skin.support.app.SkinWrapper;
import skin.support.widget.SkinCompatSupportable;

public class SkinCompatDelegate
implements LayoutInflater.Factory2 {
    private final Context mContext;
    private SkinCompatViewInflater mSkinCompatViewInflater;
    private List<WeakReference<SkinCompatSupportable>> mSkinHelpers = new CopyOnWriteArrayList<WeakReference<SkinCompatSupportable>>();

    private SkinCompatDelegate(Context context) {
        this.mContext = context;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        View view = this.createView(parent, name, context, attrs);
        if (view == null) {
            return null;
        }
        if (view instanceof SkinCompatSupportable) {
            this.mSkinHelpers.add(new WeakReference<SkinCompatSupportable>((SkinCompatSupportable)view));
        }
        return view;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = this.createView(null, name, context, attrs);
        if (view == null) {
            return null;
        }
        if (view instanceof SkinCompatSupportable) {
            this.mSkinHelpers.add(new WeakReference<SkinCompatSupportable>((SkinCompatSupportable)view));
        }
        return view;
    }

    public View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        if (this.mSkinCompatViewInflater == null) {
            this.mSkinCompatViewInflater = new SkinCompatViewInflater();
        }
        List<SkinWrapper> wrapperList = SkinCompatManager.getInstance().getWrappers();
        for (SkinWrapper wrapper : wrapperList) {
            Context wrappedContext = wrapper.wrapContext(this.mContext, parent, attrs);
            if (wrappedContext == null) continue;
            context = wrappedContext;
        }
        return this.mSkinCompatViewInflater.createView(parent, name, context, attrs);
    }

    public static SkinCompatDelegate create(Context context) {
        return new SkinCompatDelegate(context);
    }

    public void applySkin() {
        if (this.mSkinHelpers != null && !this.mSkinHelpers.isEmpty()) {
            for (WeakReference<SkinCompatSupportable> ref : this.mSkinHelpers) {
                if (ref == null || ref.get() == null) continue;
                ((SkinCompatSupportable)ref.get()).applySkin();
            }
        }
    }
}

