/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import androidx.core.view.LayoutInflaterCompat;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import skin.support.SkinCompatManager;
import skin.support.annotation.Skinable;
import skin.support.app.SkinCompatDelegate;
import skin.support.content.res.SkinCompatResources;
import skin.support.content.res.SkinCompatThemeUtils;
import skin.support.observe.SkinObservable;
import skin.support.observe.SkinObserver;
import skin.support.utils.Slog;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "SkinActivityLifecycle";
    private static volatile SkinActivityLifecycle sInstance = null;
    private WeakHashMap<Context, SkinCompatDelegate> mSkinDelegateMap;
    private WeakHashMap<Context, LazySkinObserver> mSkinObserverMap;
    private WeakReference<Activity> mCurActivityRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SkinActivityLifecycle init(Application application) {
        if (sInstance != null) return sInstance;
        Class<SkinActivityLifecycle> clazz = SkinActivityLifecycle.class;
        synchronized (SkinActivityLifecycle.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SkinActivityLifecycle(application);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private SkinActivityLifecycle(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.installLayoutFactory((Context)application);
        SkinCompatManager.getInstance().addObserver(this.getObserver((Context)application));
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.isContextSkinEnable((Context)activity)) {
            this.installLayoutFactory((Context)activity);
            this.updateWindowBackground(activity);
            if (activity instanceof SkinCompatSupportable) {
                ((SkinCompatSupportable)activity).applySkin();
            }
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.mCurActivityRef = new WeakReference<Activity>(activity);
        if (this.isContextSkinEnable((Context)activity)) {
            LazySkinObserver observer = this.getObserver((Context)activity);
            SkinCompatManager.getInstance().addObserver(observer);
            observer.updateSkinIfNeeded();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.isContextSkinEnable((Context)activity)) {
            SkinCompatManager.getInstance().deleteObserver(this.getObserver((Context)activity));
            this.mSkinObserverMap.remove(activity);
            this.mSkinDelegateMap.remove(activity);
        }
    }

    private void installLayoutFactory(Context context) {
        try {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            LayoutInflaterCompat.setFactory2((LayoutInflater)layoutInflater, (LayoutInflater.Factory2)this.getSkinDelegate(context));
        }
        catch (Throwable e) {
            Slog.i("SkinActivity", "A factory has already been set on this LayoutInflater");
        }
    }

    private SkinCompatDelegate getSkinDelegate(Context context) {
        SkinCompatDelegate mSkinDelegate;
        if (this.mSkinDelegateMap == null) {
            this.mSkinDelegateMap = new WeakHashMap();
        }
        if ((mSkinDelegate = this.mSkinDelegateMap.get(context)) == null) {
            mSkinDelegate = SkinCompatDelegate.create(context);
            this.mSkinDelegateMap.put(context, mSkinDelegate);
        }
        return mSkinDelegate;
    }

    private LazySkinObserver getObserver(Context context) {
        LazySkinObserver observer;
        if (this.mSkinObserverMap == null) {
            this.mSkinObserverMap = new WeakHashMap();
        }
        if ((observer = this.mSkinObserverMap.get(context)) == null) {
            observer = new LazySkinObserver(context);
            this.mSkinObserverMap.put(context, observer);
        }
        return observer;
    }

    private void updateWindowBackground(Activity activity) {
        Drawable drawable;
        int windowBackgroundResId;
        if (SkinCompatManager.getInstance().isSkinWindowBackgroundEnable() && SkinCompatHelper.checkResourceId(windowBackgroundResId = SkinCompatThemeUtils.getWindowBackgroundResId((Context)activity)) != 0 && (drawable = SkinCompatResources.getDrawable((Context)activity, windowBackgroundResId)) != null) {
            activity.getWindow().setBackgroundDrawable(drawable);
        }
    }

    private boolean isContextSkinEnable(Context context) {
        return SkinCompatManager.getInstance().isSkinAllActivityEnable() || context.getClass().getAnnotation(Skinable.class) != null || context instanceof SkinCompatSupportable;
    }

    private class LazySkinObserver
    implements SkinObserver {
        private final Context mContext;
        private boolean mMarkNeedUpdate = false;

        LazySkinObserver(Context context) {
            this.mContext = context;
        }

        @Override
        public void updateSkin(SkinObservable observable, Object o) {
            if (SkinActivityLifecycle.this.mCurActivityRef == null || this.mContext == SkinActivityLifecycle.this.mCurActivityRef.get() || !(this.mContext instanceof Activity)) {
                this.updateSkinForce();
            } else {
                this.mMarkNeedUpdate = true;
            }
        }

        void updateSkinIfNeeded() {
            if (this.mMarkNeedUpdate) {
                this.updateSkinForce();
            }
        }

        void updateSkinForce() {
            if (Slog.DEBUG) {
                Slog.i(SkinActivityLifecycle.TAG, "Context: " + this.mContext + " updateSkinForce");
            }
            if (this.mContext == null) {
                return;
            }
            if (this.mContext instanceof Activity && SkinActivityLifecycle.this.isContextSkinEnable(this.mContext)) {
                SkinActivityLifecycle.this.updateWindowBackground((Activity)this.mContext);
            }
            SkinActivityLifecycle.this.getSkinDelegate(this.mContext).applySkin();
            if (this.mContext instanceof SkinCompatSupportable) {
                ((SkinCompatSupportable)this.mContext).applySkin();
            }
            this.mMarkNeedUpdate = false;
        }
    }
}

