/*
 * Decompiled with CFR 0.152.
 */
package skin.support;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import skin.support.app.SkinActivityLifecycle;
import skin.support.app.SkinLayoutInflater;
import skin.support.app.SkinWrapper;
import skin.support.content.res.SkinCompatResources;
import skin.support.load.SkinAssetsLoader;
import skin.support.load.SkinBuildInLoader;
import skin.support.load.SkinNoneLoader;
import skin.support.load.SkinPrefixBuildInLoader;
import skin.support.observe.SkinObservable;
import skin.support.utils.SkinPreference;

public class SkinCompatManager
extends SkinObservable {
    public static final int SKIN_LOADER_STRATEGY_NONE = -1;
    public static final int SKIN_LOADER_STRATEGY_ASSETS = 0;
    public static final int SKIN_LOADER_STRATEGY_BUILD_IN = 1;
    public static final int SKIN_LOADER_STRATEGY_PREFIX_BUILD_IN = 2;
    private static volatile SkinCompatManager sInstance;
    private final Object mLock = new Object();
    private final Context mAppContext;
    private boolean mLoading = false;
    private List<SkinWrapper> mWrappers = new ArrayList<SkinWrapper>();
    private List<SkinLayoutInflater> mInflaters = new ArrayList<SkinLayoutInflater>();
    private List<SkinLayoutInflater> mHookInflaters = new ArrayList<SkinLayoutInflater>();
    private SparseArray<SkinLoaderStrategy> mStrategyMap = new SparseArray();
    private boolean mSkinAllActivityEnable = true;
    private boolean mSkinStatusBarColorEnable = false;
    private boolean mSkinWindowBackgroundColorEnable = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SkinCompatManager init(Context context) {
        if (sInstance == null) {
            Class<SkinCompatManager> clazz = SkinCompatManager.class;
            // MONITORENTER : skin.support.SkinCompatManager.class
            if (sInstance == null) {
                sInstance = new SkinCompatManager(context);
            }
            // MONITOREXIT : clazz
        }
        SkinPreference.init(context);
        return sInstance;
    }

    public static SkinCompatManager getInstance() {
        return sInstance;
    }

    public static SkinCompatManager withoutActivity(Application application) {
        SkinCompatManager.init((Context)application);
        SkinActivityLifecycle.init(application);
        return sInstance;
    }

    private SkinCompatManager(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.initLoaderStrategy();
    }

    private void initLoaderStrategy() {
        this.mStrategyMap.put(-1, (Object)new SkinNoneLoader());
        this.mStrategyMap.put(0, (Object)new SkinAssetsLoader());
        this.mStrategyMap.put(1, (Object)new SkinBuildInLoader());
        this.mStrategyMap.put(2, (Object)new SkinPrefixBuildInLoader());
    }

    public Context getContext() {
        return this.mAppContext;
    }

    public SkinCompatManager addStrategy(SkinLoaderStrategy strategy) {
        this.mStrategyMap.put(strategy.getType(), (Object)strategy);
        return this;
    }

    public SparseArray<SkinLoaderStrategy> getStrategies() {
        return this.mStrategyMap;
    }

    public SkinCompatManager addInflater(SkinLayoutInflater inflater) {
        if (inflater instanceof SkinWrapper) {
            this.mWrappers.add((SkinWrapper)((Object)inflater));
        }
        this.mInflaters.add(inflater);
        return this;
    }

    public List<SkinWrapper> getWrappers() {
        return this.mWrappers;
    }

    public List<SkinLayoutInflater> getInflaters() {
        return this.mInflaters;
    }

    @Deprecated
    public SkinCompatManager addHookInflater(SkinLayoutInflater inflater) {
        this.mHookInflaters.add(inflater);
        return this;
    }

    @Deprecated
    public List<SkinLayoutInflater> getHookInflaters() {
        return this.mHookInflaters;
    }

    @Deprecated
    public String getCurSkinName() {
        return SkinPreference.getInstance().getSkinName();
    }

    public void restoreDefaultTheme() {
        this.loadSkin("", -1);
    }

    public SkinCompatManager setSkinAllActivityEnable(boolean enable) {
        this.mSkinAllActivityEnable = enable;
        return this;
    }

    public boolean isSkinAllActivityEnable() {
        return this.mSkinAllActivityEnable;
    }

    @Deprecated
    public SkinCompatManager setSkinStatusBarColorEnable(boolean enable) {
        this.mSkinStatusBarColorEnable = enable;
        return this;
    }

    @Deprecated
    public boolean isSkinStatusBarColorEnable() {
        return this.mSkinStatusBarColorEnable;
    }

    public SkinCompatManager setSkinWindowBackgroundEnable(boolean enable) {
        this.mSkinWindowBackgroundColorEnable = enable;
        return this;
    }

    public boolean isSkinWindowBackgroundEnable() {
        return this.mSkinWindowBackgroundColorEnable;
    }

    public AsyncTask loadSkin() {
        String skin = SkinPreference.getInstance().getSkinName();
        int strategy = SkinPreference.getInstance().getSkinStrategy();
        if (TextUtils.isEmpty((CharSequence)skin) || strategy == -1) {
            return null;
        }
        return this.loadSkin(skin, null, strategy);
    }

    public AsyncTask loadSkin(SkinLoaderListener listener) {
        String skin = SkinPreference.getInstance().getSkinName();
        int strategy = SkinPreference.getInstance().getSkinStrategy();
        if (TextUtils.isEmpty((CharSequence)skin) || strategy == -1) {
            return null;
        }
        return this.loadSkin(skin, listener, strategy);
    }

    @Deprecated
    public AsyncTask loadSkin(String skinName) {
        return this.loadSkin(skinName, null);
    }

    @Deprecated
    public AsyncTask loadSkin(String skinName, SkinLoaderListener listener) {
        return this.loadSkin(skinName, listener, 0);
    }

    public AsyncTask loadSkin(String skinName, int strategy) {
        return this.loadSkin(skinName, null, strategy);
    }

    public AsyncTask loadSkin(String skinName, SkinLoaderListener listener, int strategy) {
        SkinLoaderStrategy loaderStrategy = (SkinLoaderStrategy)this.mStrategyMap.get(strategy);
        if (loaderStrategy == null) {
            return null;
        }
        return new SkinLoadTask(listener, loaderStrategy).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{skinName});
    }

    public String getSkinPackageName(String skinPkgPath) {
        PackageManager mPm = this.mAppContext.getPackageManager();
        PackageInfo info = mPm.getPackageArchiveInfo(skinPkgPath, 1);
        return info.packageName;
    }

    @Nullable
    public Resources getSkinResources(String skinPkgPath) {
        try {
            PackageInfo packageInfo = this.mAppContext.getPackageManager().getPackageArchiveInfo(skinPkgPath, 0);
            packageInfo.applicationInfo.sourceDir = skinPkgPath;
            packageInfo.applicationInfo.publicSourceDir = skinPkgPath;
            Resources res = this.mAppContext.getPackageManager().getResourcesForApplication(packageInfo.applicationInfo);
            Resources superRes = this.mAppContext.getResources();
            return new Resources(res.getAssets(), superRes.getDisplayMetrics(), superRes.getConfiguration());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class SkinLoadTask
    extends AsyncTask<String, Void, String> {
        private final SkinLoaderListener mListener;
        private final SkinLoaderStrategy mStrategy;

        SkinLoadTask(@NonNull SkinLoaderListener listener, SkinLoaderStrategy strategy) {
            this.mListener = listener;
            this.mStrategy = strategy;
        }

        protected void onPreExecute() {
            if (this.mListener != null) {
                this.mListener.onStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(String ... params) {
            Object object = SkinCompatManager.this.mLock;
            synchronized (object) {
                while (SkinCompatManager.this.mLoading) {
                    try {
                        SkinCompatManager.this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SkinCompatManager.this.mLoading = true;
            }
            try {
                if (params.length == 1) {
                    String skinName = this.mStrategy.loadSkinInBackground(SkinCompatManager.this.mAppContext, params[0]);
                    if (TextUtils.isEmpty((CharSequence)skinName)) {
                        SkinCompatResources.getInstance().reset(this.mStrategy);
                        return "";
                    }
                    return params[0];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SkinCompatResources.getInstance().reset();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(String skinName) {
            Object object = SkinCompatManager.this.mLock;
            synchronized (object) {
                if (skinName != null) {
                    SkinPreference.getInstance().setSkinName(skinName).setSkinStrategy(this.mStrategy.getType()).commitEditor();
                    SkinCompatManager.this.notifyUpdateSkin();
                    if (this.mListener != null) {
                        this.mListener.onSuccess();
                    }
                } else {
                    SkinPreference.getInstance().setSkinName("").setSkinStrategy(-1).commitEditor();
                    if (this.mListener != null) {
                        this.mListener.onFailed("\u76ae\u80a4\u8d44\u6e90\u83b7\u53d6\u5931\u8d25");
                    }
                }
                SkinCompatManager.this.mLoading = false;
                SkinCompatManager.this.mLock.notifyAll();
            }
        }
    }

    public static interface SkinLoaderStrategy {
        public String loadSkinInBackground(Context var1, String var2);

        public String getTargetResourceEntryName(Context var1, String var2, int var3);

        public ColorStateList getColor(Context var1, String var2, int var3);

        public ColorStateList getColorStateList(Context var1, String var2, int var3);

        public Drawable getDrawable(Context var1, String var2, int var3);

        public int getType();
    }

    public static interface SkinLoaderListener {
        public void onStart();

        public void onSuccess();

        public void onFailed(String var1);
    }
}

