/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import skin.support.R;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatImageHelper
extends SkinCompatHelper {
    private static final String TAG = SkinCompatImageHelper.class.getSimpleName();
    private final ImageView mView;
    private int mSrcResId = 0;
    private int mSrcCompatResId = 0;

    public SkinCompatImageHelper(ImageView imageView) {
        this.mView = imageView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = null;
        try {
            a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.SkinCompatImageView, defStyleAttr, 0);
            this.mSrcResId = a.getResourceId(R.styleable.SkinCompatImageView_android_src, 0);
            this.mSrcCompatResId = a.getResourceId(R.styleable.SkinCompatImageView_srcCompat, 0);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.applySkin();
    }

    public void setImageResource(int resId) {
        this.mSrcResId = resId;
        this.mSrcCompatResId = 0;
        this.applySkin();
    }

    public void applySkin() {
        this.mSrcCompatResId = SkinCompatImageHelper.checkResourceId((int)this.mSrcCompatResId);
        if (this.mSrcCompatResId != 0) {
            Drawable drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mSrcCompatResId);
            if (drawable2 != null) {
                this.mView.setImageDrawable(drawable2);
            }
        } else {
            this.mSrcResId = SkinCompatImageHelper.checkResourceId((int)this.mSrcResId);
            if (this.mSrcResId == 0) {
                return;
            }
            Drawable drawable3 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mSrcResId);
            if (drawable3 != null) {
                this.mView.setImageDrawable(drawable3);
            }
        }
    }
}

