/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import androidx.annotation.NonNull;
import skin.support.content.res.SkinCompatThemeUtils;
import skin.support.utils.SkinCompatVersionUtils;

class SkinCompatDrawableUtils {
    private static final String VECTOR_DRAWABLE_CLAZZ_NAME = "android.graphics.drawable.VectorDrawable";

    SkinCompatDrawableUtils() {
    }

    static void fixDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT == 21 && VECTOR_DRAWABLE_CLAZZ_NAME.equals(drawable2.getClass().getName())) {
            SkinCompatDrawableUtils.fixVectorDrawableTinting(drawable2);
        }
    }

    public static boolean canSafelyMutateDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 15 && drawable2 instanceof InsetDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 15 && drawable2 instanceof GradientDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 17 && drawable2 instanceof LayerDrawable) {
            return false;
        }
        if (drawable2 instanceof DrawableContainer) {
            Drawable.ConstantState state = drawable2.getConstantState();
            if (state instanceof DrawableContainer.DrawableContainerState) {
                DrawableContainer.DrawableContainerState containerState = (DrawableContainer.DrawableContainerState)state;
                for (Drawable child : containerState.getChildren()) {
                    if (SkinCompatDrawableUtils.canSafelyMutateDrawable(child)) continue;
                    return false;
                }
            }
        } else {
            Drawable scaleDrawable;
            if (SkinCompatVersionUtils.isV4DrawableWrapper((Drawable)drawable2)) {
                return SkinCompatDrawableUtils.canSafelyMutateDrawable(SkinCompatVersionUtils.getV4DrawableWrapperWrappedDrawable((Drawable)drawable2));
            }
            if (SkinCompatVersionUtils.isV4WrappedDrawable((Drawable)drawable2)) {
                return SkinCompatDrawableUtils.canSafelyMutateDrawable(SkinCompatVersionUtils.getV4WrappedDrawableWrappedDrawable((Drawable)drawable2));
            }
            if (SkinCompatVersionUtils.isV7DrawableWrapper((Drawable)drawable2)) {
                return SkinCompatDrawableUtils.canSafelyMutateDrawable(SkinCompatVersionUtils.getV7DrawableWrapperWrappedDrawable((Drawable)drawable2));
            }
            if (drawable2 instanceof ScaleDrawable && (scaleDrawable = ((ScaleDrawable)drawable2).getDrawable()) != null) {
                return SkinCompatDrawableUtils.canSafelyMutateDrawable(scaleDrawable);
            }
        }
        return true;
    }

    private static void fixVectorDrawableTinting(Drawable drawable2) {
        int[] originalState = drawable2.getState();
        if (originalState == null || originalState.length == 0) {
            drawable2.setState(SkinCompatThemeUtils.CHECKED_STATE_SET);
        } else {
            drawable2.setState(SkinCompatThemeUtils.EMPTY_STATE_SET);
        }
        drawable2.setState(originalState);
    }
}

