/*
 * Decompiled with CFR 0.152.
 */
package skin.support.app;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.TintContextWrapper;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.core.view.ViewCompat;
import skin.support.app.SkinLayoutInflater;
import skin.support.app.SkinWrapper;
import skin.support.appcompat.R;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.utils.Slog;
import skin.support.widget.SkinCompatAutoCompleteTextView;
import skin.support.widget.SkinCompatButton;
import skin.support.widget.SkinCompatCheckBox;
import skin.support.widget.SkinCompatCheckedTextView;
import skin.support.widget.SkinCompatEditText;
import skin.support.widget.SkinCompatFrameLayout;
import skin.support.widget.SkinCompatImageButton;
import skin.support.widget.SkinCompatImageView;
import skin.support.widget.SkinCompatLinearLayout;
import skin.support.widget.SkinCompatMultiAutoCompleteTextView;
import skin.support.widget.SkinCompatProgressBar;
import skin.support.widget.SkinCompatRadioButton;
import skin.support.widget.SkinCompatRadioGroup;
import skin.support.widget.SkinCompatRatingBar;
import skin.support.widget.SkinCompatRelativeLayout;
import skin.support.widget.SkinCompatScrollView;
import skin.support.widget.SkinCompatSeekBar;
import skin.support.widget.SkinCompatSpinner;
import skin.support.widget.SkinCompatSupportable;
import skin.support.widget.SkinCompatTextView;
import skin.support.widget.SkinCompatToolbar;
import skin.support.widget.SkinCompatView;

public class SkinAppCompatViewInflater
implements SkinLayoutInflater,
SkinWrapper {
    private static final String LOG_TAG = "SkinAppCompatViewInflater";

    public SkinAppCompatViewInflater() {
        SkinCompatVectorResources.getInstance();
    }

    public View createView(Context context, String name, AttributeSet attrs) {
        View view = this.createViewFromFV(context, name, attrs);
        if (view == null) {
            view = this.createViewFromV7(context, name, attrs);
        }
        return view;
    }

    private View createViewFromFV(Context context, String name, AttributeSet attrs) {
        SkinCompatSupportable view = null;
        if (name.contains(".")) {
            return null;
        }
        switch (name) {
            case "View": {
                view = new SkinCompatView(context, attrs);
                break;
            }
            case "LinearLayout": {
                view = new SkinCompatLinearLayout(context, attrs);
                break;
            }
            case "RelativeLayout": {
                view = new SkinCompatRelativeLayout(context, attrs);
                break;
            }
            case "FrameLayout": {
                view = new SkinCompatFrameLayout(context, attrs);
                break;
            }
            case "TextView": {
                view = new SkinCompatTextView(context, attrs);
                break;
            }
            case "ImageView": {
                view = new SkinCompatImageView(context, attrs);
                break;
            }
            case "Button": {
                view = new SkinCompatButton(context, attrs);
                break;
            }
            case "EditText": {
                view = new SkinCompatEditText(context, attrs);
                break;
            }
            case "Spinner": {
                view = new SkinCompatSpinner(context, attrs);
                break;
            }
            case "ImageButton": {
                view = new SkinCompatImageButton(context, attrs);
                break;
            }
            case "CheckBox": {
                view = new SkinCompatCheckBox(context, attrs);
                break;
            }
            case "RadioButton": {
                view = new SkinCompatRadioButton(context, attrs);
                break;
            }
            case "RadioGroup": {
                view = new SkinCompatRadioGroup(context, attrs);
                break;
            }
            case "CheckedTextView": {
                view = new SkinCompatCheckedTextView(context, attrs);
                break;
            }
            case "AutoCompleteTextView": {
                view = new SkinCompatAutoCompleteTextView(context, attrs);
                break;
            }
            case "MultiAutoCompleteTextView": {
                view = new SkinCompatMultiAutoCompleteTextView(context, attrs);
                break;
            }
            case "RatingBar": {
                view = new SkinCompatRatingBar(context, attrs);
                break;
            }
            case "SeekBar": {
                view = new SkinCompatSeekBar(context, attrs);
                break;
            }
            case "ProgressBar": {
                view = new SkinCompatProgressBar(context, attrs);
                break;
            }
            case "ScrollView": {
                view = new SkinCompatScrollView(context, attrs);
                break;
            }
        }
        return view;
    }

    private View createViewFromV7(Context context, String name, AttributeSet attrs) {
        SkinCompatToolbar view = null;
        switch (name) {
            case "androidx.appcompat.widget.Toolbar": {
                view = new SkinCompatToolbar(context, attrs);
                break;
            }
        }
        return view;
    }

    public Context wrapContext(Context context, View parent, AttributeSet attrs) {
        boolean inheritContext;
        boolean isPre21 = Build.VERSION.SDK_INT < 21;
        boolean bl = inheritContext = isPre21 && this.shouldInheritContext(context, (ViewParent)parent);
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        boolean readAndroidTheme = isPre21;
        boolean readAppTheme = true;
        boolean wrapContext = VectorEnabledTintResources.shouldBeUsed();
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        if (readAndroidTheme || readAppTheme) {
            context = SkinAppCompatViewInflater.themifyContext(context, attrs, readAndroidTheme, readAppTheme);
        }
        if (wrapContext) {
            context = TintContextWrapper.wrap((Context)context);
        }
        return context;
    }

    private boolean shouldInheritContext(Context context, ViewParent parent) {
        if (parent == null) {
            return false;
        }
        if (context instanceof Activity) {
            View windowDecor = ((Activity)context).getWindow().getDecorView();
            while (true) {
                if (parent == null) {
                    return true;
                }
                if (parent == windowDecor || !(parent instanceof View) || ViewCompat.isAttachedToWindow((View)((View)parent))) {
                    return false;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    private static Context themifyContext(Context context, AttributeSet attrs, boolean useAndroidTheme, boolean useAppTheme) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        int themeId = 0;
        if (useAndroidTheme) {
            themeId = a.getResourceId(R.styleable.View_android_theme, 0);
        }
        if (useAppTheme && themeId == 0 && (themeId = a.getResourceId(R.styleable.View_theme, 0)) != 0) {
            Slog.i((String)LOG_TAG, (String)"app:theme is now deprecated. Please move to using android:theme instead.");
        }
        a.recycle();
        if (!(themeId == 0 || context instanceof ContextThemeWrapper && ((ContextThemeWrapper)context).getThemeResId() == themeId)) {
            context = new ContextThemeWrapper(context, themeId);
        }
        return context;
    }
}

