/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="VolumeUsageData Usage details about the volume. This information is used by the `GET /system/df` endpoint, and omitted in other endpoints.")
public class VolumeUsageData {
    public static final String SERIALIZED_NAME_REF_COUNT = "RefCount";
    @SerializedName(value="RefCount")
    private Long refCount;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private Long size;

    public VolumeUsageData refCount(Long refCount) {
        this.refCount = refCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of containers referencing this volume. This field is set to `-1` if the reference-count is not available.")
    public Long getRefCount() {
        return this.refCount;
    }

    public void setRefCount(Long refCount) {
        this.refCount = refCount;
    }

    public VolumeUsageData size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount of disk space used by the volume (in bytes). This information is only available for volumes created with the `\"local\"` volume driver. For volumes created with other volume drivers, this field is set to `-1` (\"not available\")")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeUsageData volumeUsageData = (VolumeUsageData)o;
        return Objects.equals(this.refCount, volumeUsageData.refCount) && Objects.equals(this.size, volumeUsageData.size);
    }

    public int hashCode() {
        return Objects.hash(this.refCount, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VolumeUsageData {\n");
        sb.append("    refCount: ").append(this.toIndentedString(this.refCount)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

