/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;
import sh.ory.hydra.model.ConsentRequest;
import sh.ory.hydra.model.ConsentRequestSession;

@ApiModel(description="The response used to return used consent requests same as HandledLoginRequest, just with consent_request exposed as json")
public class PreviousConsentSession {
    public static final String SERIALIZED_NAME_CONSENT_REQUEST = "consent_request";
    @SerializedName(value="consent_request")
    private ConsentRequest consentRequest;
    public static final String SERIALIZED_NAME_GRANT_ACCESS_TOKEN_AUDIENCE = "grant_access_token_audience";
    @SerializedName(value="grant_access_token_audience")
    private List<String> grantAccessTokenAudience = null;
    public static final String SERIALIZED_NAME_GRANT_SCOPE = "grant_scope";
    @SerializedName(value="grant_scope")
    private List<String> grantScope = null;
    public static final String SERIALIZED_NAME_HANDLED_AT = "handled_at";
    @SerializedName(value="handled_at")
    private OffsetDateTime handledAt;
    public static final String SERIALIZED_NAME_REMEMBER = "remember";
    @SerializedName(value="remember")
    private Boolean remember;
    public static final String SERIALIZED_NAME_REMEMBER_FOR = "remember_for";
    @SerializedName(value="remember_for")
    private Long rememberFor;
    public static final String SERIALIZED_NAME_SESSION = "session";
    @SerializedName(value="session")
    private ConsentRequestSession session;

    public PreviousConsentSession consentRequest(ConsentRequest consentRequest) {
        this.consentRequest = consentRequest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConsentRequest getConsentRequest() {
        return this.consentRequest;
    }

    public void setConsentRequest(ConsentRequest consentRequest) {
        this.consentRequest = consentRequest;
    }

    public PreviousConsentSession grantAccessTokenAudience(List<String> grantAccessTokenAudience) {
        this.grantAccessTokenAudience = grantAccessTokenAudience;
        return this;
    }

    public PreviousConsentSession addGrantAccessTokenAudienceItem(String grantAccessTokenAudienceItem) {
        if (this.grantAccessTokenAudience == null) {
            this.grantAccessTokenAudience = new ArrayList<String>();
        }
        this.grantAccessTokenAudience.add(grantAccessTokenAudienceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getGrantAccessTokenAudience() {
        return this.grantAccessTokenAudience;
    }

    public void setGrantAccessTokenAudience(List<String> grantAccessTokenAudience) {
        this.grantAccessTokenAudience = grantAccessTokenAudience;
    }

    public PreviousConsentSession grantScope(List<String> grantScope) {
        this.grantScope = grantScope;
        return this;
    }

    public PreviousConsentSession addGrantScopeItem(String grantScopeItem) {
        if (this.grantScope == null) {
            this.grantScope = new ArrayList<String>();
        }
        this.grantScope.add(grantScopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getGrantScope() {
        return this.grantScope;
    }

    public void setGrantScope(List<String> grantScope) {
        this.grantScope = grantScope;
    }

    public PreviousConsentSession handledAt(OffsetDateTime handledAt) {
        this.handledAt = handledAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getHandledAt() {
        return this.handledAt;
    }

    public void setHandledAt(OffsetDateTime handledAt) {
        this.handledAt = handledAt;
    }

    public PreviousConsentSession remember(Boolean remember) {
        this.remember = remember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remember, if set to true, tells ORY Hydra to remember this consent authorization and reuse it if the same client asks the same user for the same, or a subset of, scope.")
    public Boolean getRemember() {
        return this.remember;
    }

    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    public PreviousConsentSession rememberFor(Long rememberFor) {
        this.rememberFor = rememberFor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RememberFor sets how long the consent authorization should be remembered for in seconds. If set to `0`, the authorization will be remembered indefinitely.")
    public Long getRememberFor() {
        return this.rememberFor;
    }

    public void setRememberFor(Long rememberFor) {
        this.rememberFor = rememberFor;
    }

    public PreviousConsentSession session(ConsentRequestSession session) {
        this.session = session;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConsentRequestSession getSession() {
        return this.session;
    }

    public void setSession(ConsentRequestSession session) {
        this.session = session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviousConsentSession previousConsentSession = (PreviousConsentSession)o;
        return Objects.equals(this.consentRequest, previousConsentSession.consentRequest) && Objects.equals(this.grantAccessTokenAudience, previousConsentSession.grantAccessTokenAudience) && Objects.equals(this.grantScope, previousConsentSession.grantScope) && Objects.equals(this.handledAt, previousConsentSession.handledAt) && Objects.equals(this.remember, previousConsentSession.remember) && Objects.equals(this.rememberFor, previousConsentSession.rememberFor) && Objects.equals(this.session, previousConsentSession.session);
    }

    public int hashCode() {
        return Objects.hash(this.consentRequest, this.grantAccessTokenAudience, this.grantScope, this.handledAt, this.remember, this.rememberFor, this.session);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreviousConsentSession {\n");
        sb.append("    consentRequest: ").append(this.toIndentedString(this.consentRequest)).append("\n");
        sb.append("    grantAccessTokenAudience: ").append(this.toIndentedString(this.grantAccessTokenAudience)).append("\n");
        sb.append("    grantScope: ").append(this.toIndentedString(this.grantScope)).append("\n");
        sb.append("    handledAt: ").append(this.toIndentedString(this.handledAt)).append("\n");
        sb.append("    remember: ").append(this.toIndentedString(this.remember)).append("\n");
        sb.append("    rememberFor: ").append(this.toIndentedString(this.rememberFor)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

